/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.security.fluent.ServerVulnerabilityAssessmentsClient;
import com.azure.resourcemanager.security.fluent.models.ServerVulnerabilityAssessmentInner;
import com.azure.resourcemanager.security.fluent.models.ServerVulnerabilityAssessmentsListInner;
import com.azure.resourcemanager.security.implementation.SecurityCenterImpl;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ServerVulnerabilityAssessmentsClientImpl
implements ServerVulnerabilityAssessmentsClient {
    private final ServerVulnerabilityAssessmentsService service;
    private final SecurityCenterImpl client;

    ServerVulnerabilityAssessmentsClientImpl(SecurityCenterImpl client) {
        this.service = (ServerVulnerabilityAssessmentsService)RestProxy.create(ServerVulnerabilityAssessmentsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ServerVulnerabilityAssessmentsListInner>> listByExtendedResourceWithResponseAsync(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String apiVersion = "2020-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByExtendedResource(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceNamespace, resourceType, resourceName, "2020-01-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ServerVulnerabilityAssessmentsListInner>> listByExtendedResourceWithResponseAsync(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String apiVersion = "2020-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByExtendedResource(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceNamespace, resourceType, resourceName, "2020-01-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ServerVulnerabilityAssessmentsListInner> listByExtendedResourceAsync(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName) {
        return this.listByExtendedResourceWithResponseAsync(resourceGroupName, resourceNamespace, resourceType, resourceName).flatMap(res -> Mono.justOrEmpty((Object)((ServerVulnerabilityAssessmentsListInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ServerVulnerabilityAssessmentsListInner> listByExtendedResourceWithResponse(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName, Context context) {
        return (Response)this.listByExtendedResourceWithResponseAsync(resourceGroupName, resourceNamespace, resourceType, resourceName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ServerVulnerabilityAssessmentsListInner listByExtendedResource(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName) {
        return (ServerVulnerabilityAssessmentsListInner)this.listByExtendedResourceWithResponse(resourceGroupName, resourceNamespace, resourceType, resourceName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ServerVulnerabilityAssessmentInner>> getWithResponseAsync(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String serverVulnerabilityAssessment = "default";
        String apiVersion = "2020-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceNamespace, resourceType, resourceName, "default", "2020-01-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ServerVulnerabilityAssessmentInner>> getWithResponseAsync(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String serverVulnerabilityAssessment = "default";
        String apiVersion = "2020-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceNamespace, resourceType, resourceName, "default", "2020-01-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ServerVulnerabilityAssessmentInner> getAsync(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName) {
        return this.getWithResponseAsync(resourceGroupName, resourceNamespace, resourceType, resourceName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ServerVulnerabilityAssessmentInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ServerVulnerabilityAssessmentInner> getWithResponse(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, resourceNamespace, resourceType, resourceName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ServerVulnerabilityAssessmentInner get(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName) {
        return (ServerVulnerabilityAssessmentInner)((Object)this.getWithResponse(resourceGroupName, resourceNamespace, resourceType, resourceName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ServerVulnerabilityAssessmentInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String serverVulnerabilityAssessment = "default";
        String apiVersion = "2020-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceNamespace, resourceType, resourceName, "default", "2020-01-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ServerVulnerabilityAssessmentInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String serverVulnerabilityAssessment = "default";
        String apiVersion = "2020-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceNamespace, resourceType, resourceName, "default", "2020-01-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ServerVulnerabilityAssessmentInner> createOrUpdateAsync(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, resourceNamespace, resourceType, resourceName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ServerVulnerabilityAssessmentInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ServerVulnerabilityAssessmentInner> createOrUpdateWithResponse(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, resourceNamespace, resourceType, resourceName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ServerVulnerabilityAssessmentInner createOrUpdate(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName) {
        return (ServerVulnerabilityAssessmentInner)((Object)this.createOrUpdateWithResponse(resourceGroupName, resourceNamespace, resourceType, resourceName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String serverVulnerabilityAssessment = "default";
        String apiVersion = "2020-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceNamespace, resourceType, resourceName, "default", "2020-01-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String serverVulnerabilityAssessment = "default";
        String apiVersion = "2020-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceNamespace, resourceType, resourceName, "default", "2020-01-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, resourceNamespace, resourceType, resourceName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, resourceNamespace, resourceType, resourceName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName) {
        return this.beginDeleteAsync(resourceGroupName, resourceNamespace, resourceType, resourceName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, resourceNamespace, resourceType, resourceName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName) {
        return this.beginDeleteAsync(resourceGroupName, resourceNamespace, resourceType, resourceName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, resourceNamespace, resourceType, resourceName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName) {
        this.deleteAsync(resourceGroupName, resourceNamespace, resourceType, resourceName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName, Context context) {
        this.deleteAsync(resourceGroupName, resourceNamespace, resourceType, resourceName, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SecurityCenterServer")
    public static interface ServerVulnerabilityAssessmentsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/serverVulnerabilityAssessments")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ServerVulnerabilityAssessmentsListInner>> listByExtendedResource(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="resourceNamespace") String var4, @PathParam(value="resourceType") String var5, @PathParam(value="resourceName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/serverVulnerabilityAssessments/{serverVulnerabilityAssessment}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ServerVulnerabilityAssessmentInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="resourceNamespace") String var4, @PathParam(value="resourceType") String var5, @PathParam(value="resourceName") String var6, @PathParam(value="serverVulnerabilityAssessment") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/serverVulnerabilityAssessments/{serverVulnerabilityAssessment}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ServerVulnerabilityAssessmentInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="resourceNamespace") String var4, @PathParam(value="resourceType") String var5, @PathParam(value="resourceName") String var6, @PathParam(value="serverVulnerabilityAssessment") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/serverVulnerabilityAssessments/{serverVulnerabilityAssessment}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="resourceNamespace") String var4, @PathParam(value="resourceType") String var5, @PathParam(value="resourceName") String var6, @PathParam(value="serverVulnerabilityAssessment") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);
    }
}

