/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.security.fluent.ServerVulnerabilityAssessmentsSettingsClient;
import com.azure.resourcemanager.security.fluent.models.ServerVulnerabilityAssessmentsSettingInner;
import com.azure.resourcemanager.security.implementation.SecurityCenterImpl;
import com.azure.resourcemanager.security.models.ServerVulnerabilityAssessmentsSettingKindName;
import com.azure.resourcemanager.security.models.ServerVulnerabilityAssessmentsSettingsList;
import reactor.core.publisher.Mono;

public final class ServerVulnerabilityAssessmentsSettingsClientImpl
implements ServerVulnerabilityAssessmentsSettingsClient {
    private final ServerVulnerabilityAssessmentsSettingsService service;
    private final SecurityCenterImpl client;

    ServerVulnerabilityAssessmentsSettingsClientImpl(SecurityCenterImpl client) {
        this.service = (ServerVulnerabilityAssessmentsSettingsService)RestProxy.create(ServerVulnerabilityAssessmentsSettingsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ServerVulnerabilityAssessmentsSettingInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2023-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2023-05-01", this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ServerVulnerabilityAssessmentsSettingsList)res.getValue()).value(), ((ServerVulnerabilityAssessmentsSettingsList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ServerVulnerabilityAssessmentsSettingInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2023-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2023-05-01", this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ServerVulnerabilityAssessmentsSettingsList)res.getValue()).value(), ((ServerVulnerabilityAssessmentsSettingsList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ServerVulnerabilityAssessmentsSettingInner> listAsync() {
        return new PagedFlux(() -> this.listSinglePageAsync(), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ServerVulnerabilityAssessmentsSettingInner> listAsync(Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(context), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ServerVulnerabilityAssessmentsSettingInner> list() {
        return new PagedIterable(this.listAsync());
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ServerVulnerabilityAssessmentsSettingInner> list(Context context) {
        return new PagedIterable(this.listAsync(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ServerVulnerabilityAssessmentsSettingInner>> getWithResponseAsync(ServerVulnerabilityAssessmentsSettingKindName settingKind) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (settingKind == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter settingKind is required and cannot be null."));
        }
        String apiVersion = "2023-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), "2023-05-01", this.client.getSubscriptionId(), settingKind, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ServerVulnerabilityAssessmentsSettingInner>> getWithResponseAsync(ServerVulnerabilityAssessmentsSettingKindName settingKind, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (settingKind == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter settingKind is required and cannot be null."));
        }
        String apiVersion = "2023-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), "2023-05-01", this.client.getSubscriptionId(), settingKind, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ServerVulnerabilityAssessmentsSettingInner> getAsync(ServerVulnerabilityAssessmentsSettingKindName settingKind) {
        return this.getWithResponseAsync(settingKind).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ServerVulnerabilityAssessmentsSettingInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ServerVulnerabilityAssessmentsSettingInner> getWithResponse(ServerVulnerabilityAssessmentsSettingKindName settingKind, Context context) {
        return (Response)this.getWithResponseAsync(settingKind, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ServerVulnerabilityAssessmentsSettingInner get(ServerVulnerabilityAssessmentsSettingKindName settingKind) {
        return (ServerVulnerabilityAssessmentsSettingInner)((Object)this.getWithResponse(settingKind, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ServerVulnerabilityAssessmentsSettingInner>> createOrUpdateWithResponseAsync(ServerVulnerabilityAssessmentsSettingKindName settingKind, ServerVulnerabilityAssessmentsSettingInner serverVulnerabilityAssessmentsSetting) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (settingKind == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter settingKind is required and cannot be null."));
        }
        if (serverVulnerabilityAssessmentsSetting == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverVulnerabilityAssessmentsSetting is required and cannot be null."));
        }
        serverVulnerabilityAssessmentsSetting.validate();
        String apiVersion = "2023-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), "2023-05-01", this.client.getSubscriptionId(), settingKind, serverVulnerabilityAssessmentsSetting, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ServerVulnerabilityAssessmentsSettingInner>> createOrUpdateWithResponseAsync(ServerVulnerabilityAssessmentsSettingKindName settingKind, ServerVulnerabilityAssessmentsSettingInner serverVulnerabilityAssessmentsSetting, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (settingKind == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter settingKind is required and cannot be null."));
        }
        if (serverVulnerabilityAssessmentsSetting == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverVulnerabilityAssessmentsSetting is required and cannot be null."));
        }
        serverVulnerabilityAssessmentsSetting.validate();
        String apiVersion = "2023-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), "2023-05-01", this.client.getSubscriptionId(), settingKind, serverVulnerabilityAssessmentsSetting, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ServerVulnerabilityAssessmentsSettingInner> createOrUpdateAsync(ServerVulnerabilityAssessmentsSettingKindName settingKind, ServerVulnerabilityAssessmentsSettingInner serverVulnerabilityAssessmentsSetting) {
        return this.createOrUpdateWithResponseAsync(settingKind, serverVulnerabilityAssessmentsSetting).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ServerVulnerabilityAssessmentsSettingInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ServerVulnerabilityAssessmentsSettingInner> createOrUpdateWithResponse(ServerVulnerabilityAssessmentsSettingKindName settingKind, ServerVulnerabilityAssessmentsSettingInner serverVulnerabilityAssessmentsSetting, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(settingKind, serverVulnerabilityAssessmentsSetting, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ServerVulnerabilityAssessmentsSettingInner createOrUpdate(ServerVulnerabilityAssessmentsSettingKindName settingKind, ServerVulnerabilityAssessmentsSettingInner serverVulnerabilityAssessmentsSetting) {
        return (ServerVulnerabilityAssessmentsSettingInner)((Object)this.createOrUpdateWithResponse(settingKind, serverVulnerabilityAssessmentsSetting, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(ServerVulnerabilityAssessmentsSettingKindName settingKind) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (settingKind == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter settingKind is required and cannot be null."));
        }
        String apiVersion = "2023-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), "2023-05-01", this.client.getSubscriptionId(), settingKind, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(ServerVulnerabilityAssessmentsSettingKindName settingKind, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (settingKind == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter settingKind is required and cannot be null."));
        }
        String apiVersion = "2023-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), "2023-05-01", this.client.getSubscriptionId(), settingKind, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(ServerVulnerabilityAssessmentsSettingKindName settingKind) {
        return this.deleteWithResponseAsync(settingKind).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(ServerVulnerabilityAssessmentsSettingKindName settingKind, Context context) {
        return (Response)this.deleteWithResponseAsync(settingKind, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(ServerVulnerabilityAssessmentsSettingKindName settingKind) {
        this.deleteWithResponse(settingKind, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ServerVulnerabilityAssessmentsSettingInner>> listBySubscriptionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ServerVulnerabilityAssessmentsSettingsList)res.getValue()).value(), ((ServerVulnerabilityAssessmentsSettingsList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ServerVulnerabilityAssessmentsSettingInner>> listBySubscriptionNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ServerVulnerabilityAssessmentsSettingsList)res.getValue()).value(), ((ServerVulnerabilityAssessmentsSettingsList)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SecurityCenterServer")
    public static interface ServerVulnerabilityAssessmentsSettingsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Security/serverVulnerabilityAssessmentsSettings")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ServerVulnerabilityAssessmentsSettingsList>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Security/serverVulnerabilityAssessmentsSettings/{settingKind}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ServerVulnerabilityAssessmentsSettingInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="settingKind") ServerVulnerabilityAssessmentsSettingKindName var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/providers/Microsoft.Security/serverVulnerabilityAssessmentsSettings/{settingKind}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ServerVulnerabilityAssessmentsSettingInner>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="settingKind") ServerVulnerabilityAssessmentsSettingKindName var4, @BodyParam(value="application/json") ServerVulnerabilityAssessmentsSettingInner var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/providers/Microsoft.Security/serverVulnerabilityAssessmentsSettings/{settingKind}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="settingKind") ServerVulnerabilityAssessmentsSettingKindName var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ServerVulnerabilityAssessmentsSettingsList>> listBySubscriptionNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

