/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.SoftwareInventoriesClient;
import com.azure.resourcemanager.security.fluent.models.SoftwareInner;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.implementation.SoftwareImpl;
import com.azure.resourcemanager.security.models.Software;
import com.azure.resourcemanager.security.models.SoftwareInventories;

public final class SoftwareInventoriesImpl
implements SoftwareInventories {
    private static final ClientLogger LOGGER = new ClientLogger(SoftwareInventoriesImpl.class);
    private final SoftwareInventoriesClient innerClient;
    private final SecurityManager serviceManager;

    public SoftwareInventoriesImpl(SoftwareInventoriesClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Software> listByExtendedResource(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName) {
        PagedIterable<SoftwareInner> inner = this.serviceClient().listByExtendedResource(resourceGroupName, resourceNamespace, resourceType, resourceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SoftwareImpl((SoftwareInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Software> listByExtendedResource(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName, Context context) {
        PagedIterable<SoftwareInner> inner = this.serviceClient().listByExtendedResource(resourceGroupName, resourceNamespace, resourceType, resourceName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SoftwareImpl((SoftwareInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Software> list() {
        PagedIterable<SoftwareInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SoftwareImpl((SoftwareInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Software> list(Context context) {
        PagedIterable<SoftwareInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SoftwareImpl((SoftwareInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Software> getWithResponse(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName, String softwareName, Context context) {
        Response<SoftwareInner> inner = this.serviceClient().getWithResponse(resourceGroupName, resourceNamespace, resourceType, resourceName, softwareName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SoftwareImpl((SoftwareInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Software get(String resourceGroupName, String resourceNamespace, String resourceType, String resourceName, String softwareName) {
        SoftwareInner inner = this.serviceClient().get(resourceGroupName, resourceNamespace, resourceType, resourceName, softwareName);
        if (inner != null) {
            return new SoftwareImpl(inner, this.manager());
        }
        return null;
    }

    private SoftwareInventoriesClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }
}

