/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.security.fluent.SqlVulnerabilityAssessmentBaselineRulesClient;
import com.azure.resourcemanager.security.fluent.models.RuleResultsInner;
import com.azure.resourcemanager.security.fluent.models.RulesResultsInner;
import com.azure.resourcemanager.security.implementation.SecurityCenterImpl;
import com.azure.resourcemanager.security.models.RuleResultsInput;
import com.azure.resourcemanager.security.models.RulesResultsInput;
import reactor.core.publisher.Mono;

public final class SqlVulnerabilityAssessmentBaselineRulesClientImpl
implements SqlVulnerabilityAssessmentBaselineRulesClient {
    private final SqlVulnerabilityAssessmentBaselineRulesService service;
    private final SecurityCenterImpl client;

    SqlVulnerabilityAssessmentBaselineRulesClientImpl(SecurityCenterImpl client) {
        this.service = (SqlVulnerabilityAssessmentBaselineRulesService)RestProxy.create(SqlVulnerabilityAssessmentBaselineRulesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RuleResultsInner>> createOrUpdateWithResponseAsync(String ruleId, String workspaceId, String resourceId, RuleResultsInput body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (ruleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleId is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (body != null) {
            body.validate();
        }
        String apiVersion = "2023-02-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), ruleId, workspaceId, "2023-02-01-preview", resourceId, body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RuleResultsInner>> createOrUpdateWithResponseAsync(String ruleId, String workspaceId, String resourceId, RuleResultsInput body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (ruleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleId is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (body != null) {
            body.validate();
        }
        String apiVersion = "2023-02-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), ruleId, workspaceId, "2023-02-01-preview", resourceId, body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RuleResultsInner> createOrUpdateAsync(String ruleId, String workspaceId, String resourceId) {
        RuleResultsInput body = null;
        return this.createOrUpdateWithResponseAsync(ruleId, workspaceId, resourceId, body).flatMap(res -> Mono.justOrEmpty((Object)((Object)((RuleResultsInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RuleResultsInner> createOrUpdateWithResponse(String ruleId, String workspaceId, String resourceId, RuleResultsInput body, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(ruleId, workspaceId, resourceId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RuleResultsInner createOrUpdate(String ruleId, String workspaceId, String resourceId) {
        RuleResultsInput body = null;
        return (RuleResultsInner)((Object)this.createOrUpdateWithResponse(ruleId, workspaceId, resourceId, body, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RuleResultsInner>> getWithResponseAsync(String ruleId, String workspaceId, String resourceId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (ruleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleId is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        String apiVersion = "2023-02-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), ruleId, workspaceId, "2023-02-01-preview", resourceId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RuleResultsInner>> getWithResponseAsync(String ruleId, String workspaceId, String resourceId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (ruleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleId is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        String apiVersion = "2023-02-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), ruleId, workspaceId, "2023-02-01-preview", resourceId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RuleResultsInner> getAsync(String ruleId, String workspaceId, String resourceId) {
        return this.getWithResponseAsync(ruleId, workspaceId, resourceId).flatMap(res -> Mono.justOrEmpty((Object)((Object)((RuleResultsInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RuleResultsInner> getWithResponse(String ruleId, String workspaceId, String resourceId, Context context) {
        return (Response)this.getWithResponseAsync(ruleId, workspaceId, resourceId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RuleResultsInner get(String ruleId, String workspaceId, String resourceId) {
        return (RuleResultsInner)((Object)this.getWithResponse(ruleId, workspaceId, resourceId, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String ruleId, String workspaceId, String resourceId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (ruleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleId is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        String apiVersion = "2023-02-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), ruleId, workspaceId, "2023-02-01-preview", resourceId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String ruleId, String workspaceId, String resourceId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (ruleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleId is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        String apiVersion = "2023-02-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), ruleId, workspaceId, "2023-02-01-preview", resourceId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String ruleId, String workspaceId, String resourceId) {
        return this.deleteWithResponseAsync(ruleId, workspaceId, resourceId).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String ruleId, String workspaceId, String resourceId, Context context) {
        return (Response)this.deleteWithResponseAsync(ruleId, workspaceId, resourceId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String ruleId, String workspaceId, String resourceId) {
        this.deleteWithResponse(ruleId, workspaceId, resourceId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RulesResultsInner>> listWithResponseAsync(String workspaceId, String resourceId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        String apiVersion = "2023-02-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), workspaceId, "2023-02-01-preview", resourceId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RulesResultsInner>> listWithResponseAsync(String workspaceId, String resourceId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        String apiVersion = "2023-02-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), workspaceId, "2023-02-01-preview", resourceId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RulesResultsInner> listAsync(String workspaceId, String resourceId) {
        return this.listWithResponseAsync(workspaceId, resourceId).flatMap(res -> Mono.justOrEmpty((Object)((RulesResultsInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RulesResultsInner> listWithResponse(String workspaceId, String resourceId, Context context) {
        return (Response)this.listWithResponseAsync(workspaceId, resourceId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RulesResultsInner list(String workspaceId, String resourceId) {
        return (RulesResultsInner)this.listWithResponse(workspaceId, resourceId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RulesResultsInner>> addWithResponseAsync(String workspaceId, String resourceId, RulesResultsInput body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (body != null) {
            body.validate();
        }
        String apiVersion = "2023-02-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.add(this.client.getEndpoint(), workspaceId, "2023-02-01-preview", resourceId, body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RulesResultsInner>> addWithResponseAsync(String workspaceId, String resourceId, RulesResultsInput body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (body != null) {
            body.validate();
        }
        String apiVersion = "2023-02-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.add(this.client.getEndpoint(), workspaceId, "2023-02-01-preview", resourceId, body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RulesResultsInner> addAsync(String workspaceId, String resourceId) {
        RulesResultsInput body = null;
        return this.addWithResponseAsync(workspaceId, resourceId, body).flatMap(res -> Mono.justOrEmpty((Object)((RulesResultsInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RulesResultsInner> addWithResponse(String workspaceId, String resourceId, RulesResultsInput body, Context context) {
        return (Response)this.addWithResponseAsync(workspaceId, resourceId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RulesResultsInner add(String workspaceId, String resourceId) {
        RulesResultsInput body = null;
        return (RulesResultsInner)this.addWithResponse(workspaceId, resourceId, body, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SecurityCenterSqlVul")
    public static interface SqlVulnerabilityAssessmentBaselineRulesService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/{ruleId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RuleResultsInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="ruleId") String var2, @QueryParam(value="workspaceId") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="resourceId", encoded=true) String var5, @BodyParam(value="application/json") RuleResultsInput var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/{ruleId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RuleResultsInner>> get(@HostParam(value="$host") String var1, @PathParam(value="ruleId") String var2, @QueryParam(value="workspaceId") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="resourceId", encoded=true) String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/{ruleId}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="ruleId") String var2, @QueryParam(value="workspaceId") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="resourceId", encoded=true) String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RulesResultsInner>> list(@HostParam(value="$host") String var1, @QueryParam(value="workspaceId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="resourceId", encoded=true) String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RulesResultsInner>> add(@HostParam(value="$host") String var1, @QueryParam(value="workspaceId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="resourceId", encoded=true) String var4, @BodyParam(value="application/json") RulesResultsInput var5, @HeaderParam(value="Accept") String var6, Context var7);
    }
}

