/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.SqlVulnerabilityAssessmentScanResultsClient;
import com.azure.resourcemanager.security.fluent.models.ScanResultInner;
import com.azure.resourcemanager.security.fluent.models.ScanResultsInner;
import com.azure.resourcemanager.security.implementation.ScanResultImpl;
import com.azure.resourcemanager.security.implementation.ScanResultsImpl;
import com.azure.resourcemanager.security.models.ScanResult;
import com.azure.resourcemanager.security.models.ScanResults;
import com.azure.resourcemanager.security.models.SqlVulnerabilityAssessmentScanResults;

public final class SqlVulnerabilityAssessmentScanResultsImpl
implements SqlVulnerabilityAssessmentScanResults {
    private static final ClientLogger LOGGER = new ClientLogger(SqlVulnerabilityAssessmentScanResultsImpl.class);
    private final SqlVulnerabilityAssessmentScanResultsClient innerClient;
    private final SecurityManager serviceManager;

    public SqlVulnerabilityAssessmentScanResultsImpl(SqlVulnerabilityAssessmentScanResultsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ScanResult> getWithResponse(String scanId, String scanResultId, String workspaceId, String resourceId, Context context) {
        Response<ScanResultInner> inner = this.serviceClient().getWithResponse(scanId, scanResultId, workspaceId, resourceId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ScanResultImpl((ScanResultInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ScanResult get(String scanId, String scanResultId, String workspaceId, String resourceId) {
        ScanResultInner inner = this.serviceClient().get(scanId, scanResultId, workspaceId, resourceId);
        if (inner != null) {
            return new ScanResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ScanResults> listWithResponse(String scanId, String workspaceId, String resourceId, Context context) {
        Response<ScanResultsInner> inner = this.serviceClient().listWithResponse(scanId, workspaceId, resourceId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ScanResultsImpl((ScanResultsInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ScanResults list(String scanId, String workspaceId, String resourceId) {
        ScanResultsInner inner = this.serviceClient().list(scanId, workspaceId, resourceId);
        if (inner != null) {
            return new ScanResultsImpl(inner, this.manager());
        }
        return null;
    }

    private SqlVulnerabilityAssessmentScanResultsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }
}

