/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.SqlVulnerabilityAssessmentScansClient;
import com.azure.resourcemanager.security.fluent.models.ScanInner;
import com.azure.resourcemanager.security.fluent.models.ScansInner;
import com.azure.resourcemanager.security.implementation.ScanImpl;
import com.azure.resourcemanager.security.implementation.ScansImpl;
import com.azure.resourcemanager.security.models.Scan;
import com.azure.resourcemanager.security.models.Scans;
import com.azure.resourcemanager.security.models.SqlVulnerabilityAssessmentScans;

public final class SqlVulnerabilityAssessmentScansImpl
implements SqlVulnerabilityAssessmentScans {
    private static final ClientLogger LOGGER = new ClientLogger(SqlVulnerabilityAssessmentScansImpl.class);
    private final SqlVulnerabilityAssessmentScansClient innerClient;
    private final SecurityManager serviceManager;

    public SqlVulnerabilityAssessmentScansImpl(SqlVulnerabilityAssessmentScansClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Scan> getWithResponse(String scanId, String workspaceId, String resourceId, Context context) {
        Response<ScanInner> inner = this.serviceClient().getWithResponse(scanId, workspaceId, resourceId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ScanImpl((ScanInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Scan get(String scanId, String workspaceId, String resourceId) {
        ScanInner inner = this.serviceClient().get(scanId, workspaceId, resourceId);
        if (inner != null) {
            return new ScanImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Scans> listWithResponse(String workspaceId, String resourceId, Context context) {
        Response<ScansInner> inner = this.serviceClient().listWithResponse(workspaceId, resourceId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ScansImpl((ScansInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public Scans list(String workspaceId, String resourceId) {
        ScansInner inner = this.serviceClient().list(workspaceId, resourceId);
        if (inner != null) {
            return new ScansImpl(inner, this.manager());
        }
        return null;
    }

    private SqlVulnerabilityAssessmentScansClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }
}

