/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.security.fluent.TasksClient;
import com.azure.resourcemanager.security.fluent.models.SecurityTaskInner;
import com.azure.resourcemanager.security.implementation.SecurityCenterImpl;
import com.azure.resourcemanager.security.models.SecurityTaskList;
import com.azure.resourcemanager.security.models.TaskUpdateActionType;
import reactor.core.publisher.Mono;

public final class TasksClientImpl
implements TasksClient {
    private final TasksService service;
    private final SecurityCenterImpl client;

    TasksClientImpl(SecurityCenterImpl client) {
        this.service = (TasksService)RestProxy.create(TasksService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SecurityTaskInner>> listSinglePageAsync(String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2015-06-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2015-06-01-preview", this.client.getSubscriptionId(), filter, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecurityTaskList)res.getValue()).value(), ((SecurityTaskList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SecurityTaskInner>> listSinglePageAsync(String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2015-06-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2015-06-01-preview", this.client.getSubscriptionId(), filter, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecurityTaskList)res.getValue()).value(), ((SecurityTaskList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SecurityTaskInner> listAsync(String filter) {
        return new PagedFlux(() -> this.listSinglePageAsync(filter), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SecurityTaskInner> listAsync() {
        String filter = null;
        return new PagedFlux(() -> this.listSinglePageAsync(filter), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SecurityTaskInner> listAsync(String filter, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(filter, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SecurityTaskInner> list() {
        String filter = null;
        return new PagedIterable(this.listAsync(filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SecurityTaskInner> list(String filter, Context context) {
        return new PagedIterable(this.listAsync(filter, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SecurityTaskInner>> listByHomeRegionSinglePageAsync(String ascLocation, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        String apiVersion = "2015-06-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByHomeRegion(this.client.getEndpoint(), "2015-06-01-preview", this.client.getSubscriptionId(), ascLocation, filter, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecurityTaskList)res.getValue()).value(), ((SecurityTaskList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SecurityTaskInner>> listByHomeRegionSinglePageAsync(String ascLocation, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        String apiVersion = "2015-06-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByHomeRegion(this.client.getEndpoint(), "2015-06-01-preview", this.client.getSubscriptionId(), ascLocation, filter, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecurityTaskList)res.getValue()).value(), ((SecurityTaskList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SecurityTaskInner> listByHomeRegionAsync(String ascLocation, String filter) {
        return new PagedFlux(() -> this.listByHomeRegionSinglePageAsync(ascLocation, filter), nextLink -> this.listByHomeRegionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SecurityTaskInner> listByHomeRegionAsync(String ascLocation) {
        String filter = null;
        return new PagedFlux(() -> this.listByHomeRegionSinglePageAsync(ascLocation, filter), nextLink -> this.listByHomeRegionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SecurityTaskInner> listByHomeRegionAsync(String ascLocation, String filter, Context context) {
        return new PagedFlux(() -> this.listByHomeRegionSinglePageAsync(ascLocation, filter, context), nextLink -> this.listByHomeRegionNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SecurityTaskInner> listByHomeRegion(String ascLocation) {
        String filter = null;
        return new PagedIterable(this.listByHomeRegionAsync(ascLocation, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SecurityTaskInner> listByHomeRegion(String ascLocation, String filter, Context context) {
        return new PagedIterable(this.listByHomeRegionAsync(ascLocation, filter, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SecurityTaskInner>> getSubscriptionLevelTaskWithResponseAsync(String ascLocation, String taskName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (taskName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter taskName is required and cannot be null."));
        }
        String apiVersion = "2015-06-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSubscriptionLevelTask(this.client.getEndpoint(), "2015-06-01-preview", this.client.getSubscriptionId(), ascLocation, taskName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SecurityTaskInner>> getSubscriptionLevelTaskWithResponseAsync(String ascLocation, String taskName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (taskName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter taskName is required and cannot be null."));
        }
        String apiVersion = "2015-06-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getSubscriptionLevelTask(this.client.getEndpoint(), "2015-06-01-preview", this.client.getSubscriptionId(), ascLocation, taskName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SecurityTaskInner> getSubscriptionLevelTaskAsync(String ascLocation, String taskName) {
        return this.getSubscriptionLevelTaskWithResponseAsync(ascLocation, taskName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((SecurityTaskInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SecurityTaskInner> getSubscriptionLevelTaskWithResponse(String ascLocation, String taskName, Context context) {
        return (Response)this.getSubscriptionLevelTaskWithResponseAsync(ascLocation, taskName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SecurityTaskInner getSubscriptionLevelTask(String ascLocation, String taskName) {
        return (SecurityTaskInner)((Object)this.getSubscriptionLevelTaskWithResponse(ascLocation, taskName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updateSubscriptionLevelTaskStateWithResponseAsync(String ascLocation, String taskName, TaskUpdateActionType taskUpdateActionType) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (taskName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter taskName is required and cannot be null."));
        }
        if (taskUpdateActionType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter taskUpdateActionType is required and cannot be null."));
        }
        String apiVersion = "2015-06-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateSubscriptionLevelTaskState(this.client.getEndpoint(), "2015-06-01-preview", this.client.getSubscriptionId(), ascLocation, taskName, taskUpdateActionType, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updateSubscriptionLevelTaskStateWithResponseAsync(String ascLocation, String taskName, TaskUpdateActionType taskUpdateActionType, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (taskName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter taskName is required and cannot be null."));
        }
        if (taskUpdateActionType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter taskUpdateActionType is required and cannot be null."));
        }
        String apiVersion = "2015-06-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateSubscriptionLevelTaskState(this.client.getEndpoint(), "2015-06-01-preview", this.client.getSubscriptionId(), ascLocation, taskName, taskUpdateActionType, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> updateSubscriptionLevelTaskStateAsync(String ascLocation, String taskName, TaskUpdateActionType taskUpdateActionType) {
        return this.updateSubscriptionLevelTaskStateWithResponseAsync(ascLocation, taskName, taskUpdateActionType).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateSubscriptionLevelTaskStateWithResponse(String ascLocation, String taskName, TaskUpdateActionType taskUpdateActionType, Context context) {
        return (Response)this.updateSubscriptionLevelTaskStateWithResponseAsync(ascLocation, taskName, taskUpdateActionType, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateSubscriptionLevelTaskState(String ascLocation, String taskName, TaskUpdateActionType taskUpdateActionType) {
        this.updateSubscriptionLevelTaskStateWithResponse(ascLocation, taskName, taskUpdateActionType, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SecurityTaskInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, String ascLocation, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        String apiVersion = "2015-06-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), "2015-06-01-preview", this.client.getSubscriptionId(), resourceGroupName, ascLocation, filter, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecurityTaskList)res.getValue()).value(), ((SecurityTaskList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SecurityTaskInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, String ascLocation, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        String apiVersion = "2015-06-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroup(this.client.getEndpoint(), "2015-06-01-preview", this.client.getSubscriptionId(), resourceGroupName, ascLocation, filter, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecurityTaskList)res.getValue()).value(), ((SecurityTaskList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SecurityTaskInner> listByResourceGroupAsync(String resourceGroupName, String ascLocation, String filter) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, ascLocation, filter), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SecurityTaskInner> listByResourceGroupAsync(String resourceGroupName, String ascLocation) {
        String filter = null;
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, ascLocation, filter), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SecurityTaskInner> listByResourceGroupAsync(String resourceGroupName, String ascLocation, String filter, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, ascLocation, filter, context), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SecurityTaskInner> listByResourceGroup(String resourceGroupName, String ascLocation) {
        String filter = null;
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, ascLocation, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SecurityTaskInner> listByResourceGroup(String resourceGroupName, String ascLocation, String filter, Context context) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, ascLocation, filter, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SecurityTaskInner>> getResourceGroupLevelTaskWithResponseAsync(String resourceGroupName, String ascLocation, String taskName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (taskName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter taskName is required and cannot be null."));
        }
        String apiVersion = "2015-06-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getResourceGroupLevelTask(this.client.getEndpoint(), "2015-06-01-preview", this.client.getSubscriptionId(), resourceGroupName, ascLocation, taskName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SecurityTaskInner>> getResourceGroupLevelTaskWithResponseAsync(String resourceGroupName, String ascLocation, String taskName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (taskName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter taskName is required and cannot be null."));
        }
        String apiVersion = "2015-06-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getResourceGroupLevelTask(this.client.getEndpoint(), "2015-06-01-preview", this.client.getSubscriptionId(), resourceGroupName, ascLocation, taskName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SecurityTaskInner> getResourceGroupLevelTaskAsync(String resourceGroupName, String ascLocation, String taskName) {
        return this.getResourceGroupLevelTaskWithResponseAsync(resourceGroupName, ascLocation, taskName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((SecurityTaskInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SecurityTaskInner> getResourceGroupLevelTaskWithResponse(String resourceGroupName, String ascLocation, String taskName, Context context) {
        return (Response)this.getResourceGroupLevelTaskWithResponseAsync(resourceGroupName, ascLocation, taskName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SecurityTaskInner getResourceGroupLevelTask(String resourceGroupName, String ascLocation, String taskName) {
        return (SecurityTaskInner)((Object)this.getResourceGroupLevelTaskWithResponse(resourceGroupName, ascLocation, taskName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updateResourceGroupLevelTaskStateWithResponseAsync(String resourceGroupName, String ascLocation, String taskName, TaskUpdateActionType taskUpdateActionType) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (taskName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter taskName is required and cannot be null."));
        }
        if (taskUpdateActionType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter taskUpdateActionType is required and cannot be null."));
        }
        String apiVersion = "2015-06-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateResourceGroupLevelTaskState(this.client.getEndpoint(), "2015-06-01-preview", this.client.getSubscriptionId(), resourceGroupName, ascLocation, taskName, taskUpdateActionType, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updateResourceGroupLevelTaskStateWithResponseAsync(String resourceGroupName, String ascLocation, String taskName, TaskUpdateActionType taskUpdateActionType, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (taskName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter taskName is required and cannot be null."));
        }
        if (taskUpdateActionType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter taskUpdateActionType is required and cannot be null."));
        }
        String apiVersion = "2015-06-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateResourceGroupLevelTaskState(this.client.getEndpoint(), "2015-06-01-preview", this.client.getSubscriptionId(), resourceGroupName, ascLocation, taskName, taskUpdateActionType, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> updateResourceGroupLevelTaskStateAsync(String resourceGroupName, String ascLocation, String taskName, TaskUpdateActionType taskUpdateActionType) {
        return this.updateResourceGroupLevelTaskStateWithResponseAsync(resourceGroupName, ascLocation, taskName, taskUpdateActionType).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateResourceGroupLevelTaskStateWithResponse(String resourceGroupName, String ascLocation, String taskName, TaskUpdateActionType taskUpdateActionType, Context context) {
        return (Response)this.updateResourceGroupLevelTaskStateWithResponseAsync(resourceGroupName, ascLocation, taskName, taskUpdateActionType, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateResourceGroupLevelTaskState(String resourceGroupName, String ascLocation, String taskName, TaskUpdateActionType taskUpdateActionType) {
        this.updateResourceGroupLevelTaskStateWithResponse(resourceGroupName, ascLocation, taskName, taskUpdateActionType, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SecurityTaskInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecurityTaskList)res.getValue()).value(), ((SecurityTaskList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SecurityTaskInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecurityTaskList)res.getValue()).value(), ((SecurityTaskList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SecurityTaskInner>> listByHomeRegionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByHomeRegionNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecurityTaskList)res.getValue()).value(), ((SecurityTaskList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SecurityTaskInner>> listByHomeRegionNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByHomeRegionNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecurityTaskList)res.getValue()).value(), ((SecurityTaskList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SecurityTaskInner>> listByResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecurityTaskList)res.getValue()).value(), ((SecurityTaskList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SecurityTaskInner>> listByResourceGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecurityTaskList)res.getValue()).value(), ((SecurityTaskList)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SecurityCenterTasks")
    public static interface TasksService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Security/tasks")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SecurityTaskList>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @QueryParam(value="$filter") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Security/locations/{ascLocation}/tasks")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SecurityTaskList>> listByHomeRegion(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="ascLocation") String var4, @QueryParam(value="$filter") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Security/locations/{ascLocation}/tasks/{taskName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SecurityTaskInner>> getSubscriptionLevelTask(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="ascLocation") String var4, @PathParam(value="taskName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Security/locations/{ascLocation}/tasks/{taskName}/{taskUpdateActionType}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> updateSubscriptionLevelTaskState(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="ascLocation") String var4, @PathParam(value="taskName") String var5, @PathParam(value="taskUpdateActionType") TaskUpdateActionType var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/tasks")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SecurityTaskList>> listByResourceGroup(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="ascLocation") String var5, @QueryParam(value="$filter") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/tasks/{taskName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SecurityTaskInner>> getResourceGroupLevelTask(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="ascLocation") String var5, @PathParam(value="taskName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/tasks/{taskName}/{taskUpdateActionType}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> updateResourceGroupLevelTaskState(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="ascLocation") String var5, @PathParam(value="taskName") String var6, @PathParam(value="taskUpdateActionType") TaskUpdateActionType var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SecurityTaskList>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SecurityTaskList>> listByHomeRegionNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SecurityTaskList>> listByResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

