/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.models;

import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.security.fluent.models.AdaptiveApplicationControlGroupInner;
import com.azure.resourcemanager.security.models.AdaptiveApplicationControlIssueSummary;
import com.azure.resourcemanager.security.models.ConfigurationStatus;
import com.azure.resourcemanager.security.models.EnforcementMode;
import com.azure.resourcemanager.security.models.PathRecommendation;
import com.azure.resourcemanager.security.models.ProtectionMode;
import com.azure.resourcemanager.security.models.RecommendationStatus;
import com.azure.resourcemanager.security.models.SourceSystem;
import com.azure.resourcemanager.security.models.VmRecommendation;
import java.util.List;

public interface AdaptiveApplicationControlGroup {
    public String id();

    public String name();

    public String type();

    public String location();

    public EnforcementMode enforcementMode();

    public ProtectionMode protectionMode();

    public ConfigurationStatus configurationStatus();

    public RecommendationStatus recommendationStatus();

    public List<AdaptiveApplicationControlIssueSummary> issues();

    public SourceSystem sourceSystem();

    public List<VmRecommendation> vmRecommendations();

    public List<PathRecommendation> pathRecommendations();

    public Region region();

    public String regionName();

    public AdaptiveApplicationControlGroupInner innerModel();

    public Update update();

    public AdaptiveApplicationControlGroup refresh();

    public AdaptiveApplicationControlGroup refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithPathRecommendations {
            public Update withPathRecommendations(List<PathRecommendation> var1);
        }

        public static interface WithVmRecommendations {
            public Update withVmRecommendations(List<VmRecommendation> var1);
        }

        public static interface WithProtectionMode {
            public Update withProtectionMode(ProtectionMode var1);
        }

        public static interface WithEnforcementMode {
            public Update withEnforcementMode(EnforcementMode var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithEnforcementMode,
    UpdateStages.WithProtectionMode,
    UpdateStages.WithVmRecommendations,
    UpdateStages.WithPathRecommendations {
        public AdaptiveApplicationControlGroup apply();

        public AdaptiveApplicationControlGroup apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithPathRecommendations {
            public WithCreate withPathRecommendations(List<PathRecommendation> var1);
        }

        public static interface WithVmRecommendations {
            public WithCreate withVmRecommendations(List<VmRecommendation> var1);
        }

        public static interface WithProtectionMode {
            public WithCreate withProtectionMode(ProtectionMode var1);
        }

        public static interface WithEnforcementMode {
            public WithCreate withEnforcementMode(EnforcementMode var1);
        }

        public static interface WithCreate
        extends WithEnforcementMode,
        WithProtectionMode,
        WithVmRecommendations,
        WithPathRecommendations {
            public AdaptiveApplicationControlGroup create();

            public AdaptiveApplicationControlGroup create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingLocation(String var1);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

