/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.models.AuthenticationDetailsProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="authenticationType")
@JsonTypeName(value="awsCreds")
public final class AwsCredsAuthenticationDetailsProperties
extends AuthenticationDetailsProperties {
    @JsonProperty(value="accountId", access=JsonProperty.Access.WRITE_ONLY)
    private String accountId;
    @JsonProperty(value="awsAccessKeyId", required=true)
    private String awsAccessKeyId;
    @JsonProperty(value="awsSecretAccessKey", required=true)
    private String awsSecretAccessKey;
    private static final ClientLogger LOGGER = new ClientLogger(AwsCredsAuthenticationDetailsProperties.class);

    public String accountId() {
        return this.accountId;
    }

    public String awsAccessKeyId() {
        return this.awsAccessKeyId;
    }

    public AwsCredsAuthenticationDetailsProperties withAwsAccessKeyId(String awsAccessKeyId) {
        this.awsAccessKeyId = awsAccessKeyId;
        return this;
    }

    public String awsSecretAccessKey() {
        return this.awsSecretAccessKey;
    }

    public AwsCredsAuthenticationDetailsProperties withAwsSecretAccessKey(String awsSecretAccessKey) {
        this.awsSecretAccessKey = awsSecretAccessKey;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.awsAccessKeyId() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property awsAccessKeyId in model AwsCredsAuthenticationDetailsProperties"));
        }
        if (this.awsSecretAccessKey() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property awsSecretAccessKey in model AwsCredsAuthenticationDetailsProperties"));
        }
    }
}

