/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.models;

import com.azure.core.util.Context;
import com.azure.resourcemanager.security.fluent.models.DeviceSecurityGroupInner;
import com.azure.resourcemanager.security.models.AllowlistCustomAlertRule;
import com.azure.resourcemanager.security.models.DenylistCustomAlertRule;
import com.azure.resourcemanager.security.models.ThresholdCustomAlertRule;
import com.azure.resourcemanager.security.models.TimeWindowCustomAlertRule;
import java.util.List;

public interface DeviceSecurityGroup {
    public String id();

    public String name();

    public String type();

    public List<ThresholdCustomAlertRule> thresholdRules();

    public List<TimeWindowCustomAlertRule> timeWindowRules();

    public List<AllowlistCustomAlertRule> allowlistRules();

    public List<DenylistCustomAlertRule> denylistRules();

    public DeviceSecurityGroupInner innerModel();

    public Update update();

    public DeviceSecurityGroup refresh();

    public DeviceSecurityGroup refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithDenylistRules {
            public Update withDenylistRules(List<DenylistCustomAlertRule> var1);
        }

        public static interface WithAllowlistRules {
            public Update withAllowlistRules(List<AllowlistCustomAlertRule> var1);
        }

        public static interface WithTimeWindowRules {
            public Update withTimeWindowRules(List<TimeWindowCustomAlertRule> var1);
        }

        public static interface WithThresholdRules {
            public Update withThresholdRules(List<ThresholdCustomAlertRule> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithThresholdRules,
    UpdateStages.WithTimeWindowRules,
    UpdateStages.WithAllowlistRules,
    UpdateStages.WithDenylistRules {
        public DeviceSecurityGroup apply();

        public DeviceSecurityGroup apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithDenylistRules {
            public WithCreate withDenylistRules(List<DenylistCustomAlertRule> var1);
        }

        public static interface WithAllowlistRules {
            public WithCreate withAllowlistRules(List<AllowlistCustomAlertRule> var1);
        }

        public static interface WithTimeWindowRules {
            public WithCreate withTimeWindowRules(List<TimeWindowCustomAlertRule> var1);
        }

        public static interface WithThresholdRules {
            public WithCreate withThresholdRules(List<ThresholdCustomAlertRule> var1);
        }

        public static interface WithCreate
        extends WithThresholdRules,
        WithTimeWindowRules,
        WithAllowlistRules,
        WithDenylistRules {
            public DeviceSecurityGroup create();

            public DeviceSecurityGroup create(Context var1);
        }

        public static interface WithScope {
            public WithCreate withExistingResourceId(String var1);
        }

        public static interface Blank
        extends WithScope {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithScope,
    DefinitionStages.WithCreate {
    }
}

