/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.models;

import com.azure.core.util.Context;
import com.azure.resourcemanager.security.fluent.models.GovernanceRuleInner;
import com.azure.resourcemanager.security.models.ExecuteGovernanceRuleParams;
import com.azure.resourcemanager.security.models.GovernanceRuleEmailNotification;
import com.azure.resourcemanager.security.models.GovernanceRuleMetadata;
import com.azure.resourcemanager.security.models.GovernanceRuleOwnerSource;
import com.azure.resourcemanager.security.models.GovernanceRuleSourceResourceType;
import com.azure.resourcemanager.security.models.GovernanceRuleType;
import java.util.List;

public interface GovernanceRule {
    public String id();

    public String name();

    public String type();

    public String tenantId();

    public String displayName();

    public String description();

    public String remediationTimeframe();

    public Boolean isGracePeriod();

    public int rulePriority();

    public Boolean isDisabled();

    public GovernanceRuleType ruleType();

    public GovernanceRuleSourceResourceType sourceResourceType();

    public List<String> excludedScopes();

    public List<Object> conditionSets();

    public Boolean includeMemberScopes();

    public GovernanceRuleOwnerSource ownerSource();

    public GovernanceRuleEmailNotification governanceEmailNotification();

    public GovernanceRuleMetadata metadata();

    public GovernanceRuleInner innerModel();

    public Update update();

    public GovernanceRule refresh();

    public GovernanceRule refresh(Context var1);

    public void execute();

    public void execute(ExecuteGovernanceRuleParams var1, Context var2);

    public static interface UpdateStages {

        public static interface WithMetadata {
            public Update withMetadata(GovernanceRuleMetadata var1);
        }

        public static interface WithGovernanceEmailNotification {
            public Update withGovernanceEmailNotification(GovernanceRuleEmailNotification var1);
        }

        public static interface WithOwnerSource {
            public Update withOwnerSource(GovernanceRuleOwnerSource var1);
        }

        public static interface WithIncludeMemberScopes {
            public Update withIncludeMemberScopes(Boolean var1);
        }

        public static interface WithConditionSets {
            public Update withConditionSets(List<Object> var1);
        }

        public static interface WithExcludedScopes {
            public Update withExcludedScopes(List<String> var1);
        }

        public static interface WithSourceResourceType {
            public Update withSourceResourceType(GovernanceRuleSourceResourceType var1);
        }

        public static interface WithRuleType {
            public Update withRuleType(GovernanceRuleType var1);
        }

        public static interface WithIsDisabled {
            public Update withIsDisabled(Boolean var1);
        }

        public static interface WithRulePriority {
            public Update withRulePriority(int var1);
        }

        public static interface WithIsGracePeriod {
            public Update withIsGracePeriod(Boolean var1);
        }

        public static interface WithRemediationTimeframe {
            public Update withRemediationTimeframe(String var1);
        }

        public static interface WithDescription {
            public Update withDescription(String var1);
        }

        public static interface WithDisplayName {
            public Update withDisplayName(String var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithDisplayName,
    UpdateStages.WithDescription,
    UpdateStages.WithRemediationTimeframe,
    UpdateStages.WithIsGracePeriod,
    UpdateStages.WithRulePriority,
    UpdateStages.WithIsDisabled,
    UpdateStages.WithRuleType,
    UpdateStages.WithSourceResourceType,
    UpdateStages.WithExcludedScopes,
    UpdateStages.WithConditionSets,
    UpdateStages.WithIncludeMemberScopes,
    UpdateStages.WithOwnerSource,
    UpdateStages.WithGovernanceEmailNotification,
    UpdateStages.WithMetadata {
        public GovernanceRule apply();

        public GovernanceRule apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithMetadata {
            public WithCreate withMetadata(GovernanceRuleMetadata var1);
        }

        public static interface WithGovernanceEmailNotification {
            public WithCreate withGovernanceEmailNotification(GovernanceRuleEmailNotification var1);
        }

        public static interface WithOwnerSource {
            public WithCreate withOwnerSource(GovernanceRuleOwnerSource var1);
        }

        public static interface WithIncludeMemberScopes {
            public WithCreate withIncludeMemberScopes(Boolean var1);
        }

        public static interface WithConditionSets {
            public WithCreate withConditionSets(List<Object> var1);
        }

        public static interface WithExcludedScopes {
            public WithCreate withExcludedScopes(List<String> var1);
        }

        public static interface WithSourceResourceType {
            public WithCreate withSourceResourceType(GovernanceRuleSourceResourceType var1);
        }

        public static interface WithRuleType {
            public WithCreate withRuleType(GovernanceRuleType var1);
        }

        public static interface WithIsDisabled {
            public WithCreate withIsDisabled(Boolean var1);
        }

        public static interface WithRulePriority {
            public WithCreate withRulePriority(int var1);
        }

        public static interface WithIsGracePeriod {
            public WithCreate withIsGracePeriod(Boolean var1);
        }

        public static interface WithRemediationTimeframe {
            public WithCreate withRemediationTimeframe(String var1);
        }

        public static interface WithDescription {
            public WithCreate withDescription(String var1);
        }

        public static interface WithDisplayName {
            public WithCreate withDisplayName(String var1);
        }

        public static interface WithCreate
        extends WithDisplayName,
        WithDescription,
        WithRemediationTimeframe,
        WithIsGracePeriod,
        WithRulePriority,
        WithIsDisabled,
        WithRuleType,
        WithSourceResourceType,
        WithExcludedScopes,
        WithConditionSets,
        WithIncludeMemberScopes,
        WithOwnerSource,
        WithGovernanceEmailNotification,
        WithMetadata {
            public GovernanceRule create();

            public GovernanceRule create(Context var1);
        }

        public static interface WithScope {
            public WithCreate withExistingScope(String var1);
        }

        public static interface Blank
        extends WithScope {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithScope,
    DefinitionStages.WithCreate {
    }
}

