/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.models.AutoProvision;
import com.azure.resourcemanager.security.models.HybridComputeProvisioningState;
import com.azure.resourcemanager.security.models.ProxyServerProperties;
import com.azure.resourcemanager.security.models.ServicePrincipalProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class HybridComputeSettingsProperties {
    @JsonProperty(value="hybridComputeProvisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private HybridComputeProvisioningState hybridComputeProvisioningState;
    @JsonProperty(value="autoProvision", required=true)
    private AutoProvision autoProvision;
    @JsonProperty(value="resourceGroupName")
    private String resourceGroupName;
    @JsonProperty(value="region")
    private String region;
    @JsonProperty(value="proxyServer")
    private ProxyServerProperties proxyServer;
    @JsonProperty(value="servicePrincipal")
    private ServicePrincipalProperties servicePrincipal;
    private static final ClientLogger LOGGER = new ClientLogger(HybridComputeSettingsProperties.class);

    public HybridComputeProvisioningState hybridComputeProvisioningState() {
        return this.hybridComputeProvisioningState;
    }

    public AutoProvision autoProvision() {
        return this.autoProvision;
    }

    public HybridComputeSettingsProperties withAutoProvision(AutoProvision autoProvision) {
        this.autoProvision = autoProvision;
        return this;
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    public HybridComputeSettingsProperties withResourceGroupName(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    public String region() {
        return this.region;
    }

    public HybridComputeSettingsProperties withRegion(String region) {
        this.region = region;
        return this;
    }

    public ProxyServerProperties proxyServer() {
        return this.proxyServer;
    }

    public HybridComputeSettingsProperties withProxyServer(ProxyServerProperties proxyServer) {
        this.proxyServer = proxyServer;
        return this;
    }

    public ServicePrincipalProperties servicePrincipal() {
        return this.servicePrincipal;
    }

    public HybridComputeSettingsProperties withServicePrincipal(ServicePrincipalProperties servicePrincipal) {
        this.servicePrincipal = servicePrincipal;
        return this;
    }

    public void validate() {
        if (this.autoProvision() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property autoProvision in model HybridComputeSettingsProperties"));
        }
        if (this.proxyServer() != null) {
            this.proxyServer().validate();
        }
        if (this.servicePrincipal() != null) {
            this.servicePrincipal().validate();
        }
    }
}

