/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.security.fluent.models.IoTSecuritySolutionModelInner;
import com.azure.resourcemanager.security.models.AdditionalWorkspacesProperties;
import com.azure.resourcemanager.security.models.DataSource;
import com.azure.resourcemanager.security.models.ExportData;
import com.azure.resourcemanager.security.models.RecommendationConfigurationProperties;
import com.azure.resourcemanager.security.models.SecuritySolutionStatus;
import com.azure.resourcemanager.security.models.UnmaskedIpLoggingStatus;
import com.azure.resourcemanager.security.models.UserDefinedResourcesProperties;
import java.util.List;
import java.util.Map;

public interface IoTSecuritySolutionModel {
    public String id();

    public String name();

    public String type();

    public String location();

    public SystemData systemData();

    public Map<String, String> tags();

    public String workspace();

    public String displayName();

    public SecuritySolutionStatus status();

    public List<ExportData> export();

    public List<DataSource> disabledDataSources();

    public List<String> iotHubs();

    public UserDefinedResourcesProperties userDefinedResources();

    public List<String> autoDiscoveredResources();

    public List<RecommendationConfigurationProperties> recommendationsConfiguration();

    public UnmaskedIpLoggingStatus unmaskedIpLoggingStatus();

    public List<AdditionalWorkspacesProperties> additionalWorkspaces();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public IoTSecuritySolutionModelInner innerModel();

    public Update update();

    public IoTSecuritySolutionModel refresh();

    public IoTSecuritySolutionModel refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithRecommendationsConfiguration {
            public Update withRecommendationsConfiguration(List<RecommendationConfigurationProperties> var1);
        }

        public static interface WithUserDefinedResources {
            public Update withUserDefinedResources(UserDefinedResourcesProperties var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithUserDefinedResources,
    UpdateStages.WithRecommendationsConfiguration {
        public IoTSecuritySolutionModel apply();

        public IoTSecuritySolutionModel apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithAdditionalWorkspaces {
            public WithCreate withAdditionalWorkspaces(List<AdditionalWorkspacesProperties> var1);
        }

        public static interface WithUnmaskedIpLoggingStatus {
            public WithCreate withUnmaskedIpLoggingStatus(UnmaskedIpLoggingStatus var1);
        }

        public static interface WithRecommendationsConfiguration {
            public WithCreate withRecommendationsConfiguration(List<RecommendationConfigurationProperties> var1);
        }

        public static interface WithUserDefinedResources {
            public WithCreate withUserDefinedResources(UserDefinedResourcesProperties var1);
        }

        public static interface WithIotHubs {
            public WithCreate withIotHubs(List<String> var1);
        }

        public static interface WithDisabledDataSources {
            public WithCreate withDisabledDataSources(List<DataSource> var1);
        }

        public static interface WithExport {
            public WithCreate withExport(List<ExportData> var1);
        }

        public static interface WithStatus {
            public WithCreate withStatus(SecuritySolutionStatus var1);
        }

        public static interface WithDisplayName {
            public WithCreate withDisplayName(String var1);
        }

        public static interface WithWorkspace {
            public WithCreate withWorkspace(String var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithLocation {
            public WithCreate withRegion(Region var1);

            public WithCreate withRegion(String var1);
        }

        public static interface WithCreate
        extends WithLocation,
        WithTags,
        WithWorkspace,
        WithDisplayName,
        WithStatus,
        WithExport,
        WithDisabledDataSources,
        WithIotHubs,
        WithUserDefinedResources,
        WithRecommendationsConfiguration,
        WithUnmaskedIpLoggingStatus,
        WithAdditionalWorkspaces {
            public IoTSecuritySolutionModel create();

            public IoTSecuritySolutionModel create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface Blank
        extends WithResourceGroup {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

