/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.models;

import com.azure.core.util.Context;
import com.azure.resourcemanager.security.fluent.models.SecurityAssessmentMetadataProperties;
import com.azure.resourcemanager.security.fluent.models.SecurityAssessmentResponseInner;
import com.azure.resourcemanager.security.models.AssessmentLinks;
import com.azure.resourcemanager.security.models.AssessmentStatus;
import com.azure.resourcemanager.security.models.AssessmentStatusResponse;
import com.azure.resourcemanager.security.models.ResourceDetails;
import com.azure.resourcemanager.security.models.SecurityAssessmentPartnerData;
import java.util.Map;

public interface SecurityAssessmentResponse {
    public String id();

    public String name();

    public String type();

    public AssessmentStatusResponse status();

    public ResourceDetails resourceDetails();

    public String displayName();

    public Map<String, String> additionalData();

    public AssessmentLinks links();

    public SecurityAssessmentMetadataProperties metadata();

    public SecurityAssessmentPartnerData partnersData();

    public SecurityAssessmentResponseInner innerModel();

    public Update update();

    public SecurityAssessmentResponse refresh();

    public SecurityAssessmentResponse refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithPartnersData {
            public Update withPartnersData(SecurityAssessmentPartnerData var1);
        }

        public static interface WithMetadata {
            public Update withMetadata(SecurityAssessmentMetadataProperties var1);
        }

        public static interface WithAdditionalData {
            public Update withAdditionalData(Map<String, String> var1);
        }

        public static interface WithResourceDetails {
            public Update withResourceDetails(ResourceDetails var1);
        }

        public static interface WithStatus {
            public Update withStatus(AssessmentStatus var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithStatus,
    UpdateStages.WithResourceDetails,
    UpdateStages.WithAdditionalData,
    UpdateStages.WithMetadata,
    UpdateStages.WithPartnersData {
        public SecurityAssessmentResponse apply();

        public SecurityAssessmentResponse apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithPartnersData {
            public WithCreate withPartnersData(SecurityAssessmentPartnerData var1);
        }

        public static interface WithMetadata {
            public WithCreate withMetadata(SecurityAssessmentMetadataProperties var1);
        }

        public static interface WithAdditionalData {
            public WithCreate withAdditionalData(Map<String, String> var1);
        }

        public static interface WithResourceDetails {
            public WithCreate withResourceDetails(ResourceDetails var1);
        }

        public static interface WithStatus {
            public WithCreate withStatus(AssessmentStatus var1);
        }

        public static interface WithCreate
        extends WithStatus,
        WithResourceDetails,
        WithAdditionalData,
        WithMetadata,
        WithPartnersData {
            public SecurityAssessmentResponse create();

            public SecurityAssessmentResponse create(Context var1);
        }

        public static interface WithScope {
            public WithCreate withExistingResourceId(String var1);
        }

        public static interface Blank
        extends WithScope {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithScope,
    DefinitionStages.WithCreate {
    }
}

