/*
 * Decompiled with CFR 0.152.
 */
package com.azure.autorest.customization;

import com.azure.autorest.customization.ClassCustomization;
import com.azure.autorest.customization.CodeCustomization;
import com.azure.autorest.customization.Editor;
import com.azure.autorest.customization.JavadocCustomization;
import com.azure.autorest.customization.PackageCustomization;
import com.azure.autorest.customization.implementation.Utils;
import com.azure.autorest.customization.implementation.ls.EclipseLanguageClient;
import com.azure.autorest.customization.implementation.ls.models.SymbolInformation;
import com.github.javaparser.Range;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import java.lang.reflect.Modifier;
import java.util.List;

public final class ConstructorCustomization
extends CodeCustomization {
    private final String packageName;
    private final String className;
    private final String constructorSignature;

    ConstructorCustomization(Editor editor, EclipseLanguageClient languageClient, String packageName, String className, String constructorSignature, SymbolInformation symbol) {
        super(editor, languageClient, symbol);
        this.packageName = packageName;
        this.className = className;
        this.constructorSignature = constructorSignature;
    }

    public String getClassName() {
        return this.className;
    }

    public JavadocCustomization getJavadoc() {
        return new JavadocCustomization(this.editor, this.languageClient, this.fileUri, this.fileName, this.symbol.getLocation().getRange().getStart().getLine());
    }

    public ConstructorCustomization addAnnotation(String annotation) {
        return Utils.addAnnotation(annotation, this, () -> this.refreshCustomization(this.constructorSignature));
    }

    public ConstructorCustomization removeAnnotation(String annotation) {
        return Utils.removeAnnotation(this, compilationUnit -> ((ClassOrInterfaceDeclaration)compilationUnit.getClassByName(this.className).get()).getConstructors().stream().filter(ctor -> Utils.declarationContainsSymbol((Range)ctor.getRange().get(), this.symbol.getLocation().getRange())).findFirst().get().getAnnotationByName(Utils.cleanAnnotationName(annotation)), () -> this.refreshCustomization(this.constructorSignature));
    }

    public ConstructorCustomization setModifier(int modifiers) {
        Utils.replaceModifier(this.symbol, this.editor, this.languageClient, "(?:.+ )?" + this.className + "\\(", this.className + "(", Modifier.constructorModifiers(), modifiers);
        return this.refreshCustomization(this.constructorSignature);
    }

    public ConstructorCustomization replaceParameters(String newParameters) {
        return this.replaceParameters(newParameters, null);
    }

    public ConstructorCustomization replaceParameters(String newParameters, List<String> importsToAdd) {
        String newSignature = this.className + "(" + newParameters + ")";
        ClassCustomization classCustomization = new PackageCustomization(this.editor, this.languageClient, this.packageName).getClass(this.className);
        ClassCustomization updatedClassCustomization = Utils.addImports(importsToAdd, classCustomization, classCustomization::refreshSymbol);
        return Utils.replaceParameters(newParameters, updatedClassCustomization.getConstructor(this.constructorSignature), () -> updatedClassCustomization.getConstructor(newSignature));
    }

    public ConstructorCustomization replaceBody(String newBody) {
        return this.replaceBody(newBody, null);
    }

    public ConstructorCustomization replaceBody(String newBody, List<String> importsToAdd) {
        ClassCustomization classCustomization = new PackageCustomization(this.editor, this.languageClient, this.packageName).getClass(this.className);
        ClassCustomization updatedClassCustomization = Utils.addImports(importsToAdd, classCustomization, classCustomization::refreshSymbol);
        return Utils.replaceBody(newBody, updatedClassCustomization.getConstructor(this.constructorSignature), () -> updatedClassCustomization.getConstructor(this.constructorSignature));
    }

    private ConstructorCustomization refreshCustomization(String constructorSignature) {
        return new PackageCustomization(this.editor, this.languageClient, this.packageName).getClass(this.className).getConstructor(constructorSignature);
    }
}

