/*
 * Decompiled with CFR 0.152.
 */
package com.azure.autorest.customization;

import com.azure.autorest.customization.Editor;
import com.azure.autorest.customization.LibraryCustomization;
import com.azure.autorest.customization.implementation.Utils;
import com.azure.autorest.customization.implementation.ls.EclipseLanguageClient;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.slf4j.Logger;

public abstract class Customization {
    public final Map<String, String> run(Map<String, String> files, Logger logger) {
        return this.run(null, files, logger);
    }

    final Map<String, String> run(String pathToLanguageServerPlugin, Map<String, String> files, Logger logger) {
        Editor editor;
        Path tempDirWithPrefix;
        try {
            tempDirWithPrefix = Files.createTempDirectory("temp", new FileAttribute[0]);
            editor = new Editor(files, tempDirWithPrefix);
            InputStream pomStream = Customization.class.getResourceAsStream("/pom.xml");
            byte[] buffer = new byte[pomStream.available()];
            pomStream.read(buffer);
            editor.addFile("pom.xml", new String(buffer, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            EclipseLanguageClient languageClient = new EclipseLanguageClient(pathToLanguageServerPlugin, tempDirWithPrefix.toString());
            try {
                languageClient.initialize();
                this.customize(new LibraryCustomization(editor, languageClient), logger);
                editor.removeFile("pom.xml");
                Map<String, String> map = editor.getContents();
                languageClient.close();
                return map;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        languageClient.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        finally {
            Utils.deleteDirectory(tempDirWithPrefix.toFile());
        }
    }

    public abstract void customize(LibraryCustomization var1, Logger var2);
}

