/*
 * Decompiled with CFR 0.152.
 */
package com.azure.autorest.customization;

import com.azure.autorest.customization.implementation.Utils;
import com.azure.autorest.customization.models.Position;
import com.azure.autorest.customization.models.Range;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class Editor {
    private final Path rootDir;
    private final Map<String, String> contents;
    private final Map<String, List<String>> lines;
    private final Map<String, Path> paths;

    public Editor(Map<String, String> contents, Path rootDir) {
        this.contents = new HashMap<String, String>(contents);
        this.lines = new HashMap<String, List<String>>();
        this.paths = new HashMap<String, Path>();
        this.rootDir = rootDir;
        for (Map.Entry<String, String> content : contents.entrySet()) {
            this.addFile(content.getKey(), content.getValue());
        }
    }

    public Map<String, String> getContents() {
        return this.contents;
    }

    public void addFile(String name, String content) {
        this.addOrReplaceFile(name, content, false);
    }

    public void replaceFile(String name, String content) {
        this.addOrReplaceFile(name, content, true);
    }

    private void addOrReplaceFile(String name, String content, boolean isReplace) {
        Path newFilePath = Paths.get(this.rootDir.toString(), name);
        File newFile = newFilePath.toFile();
        if (!newFile.getParentFile().exists()) {
            newFile.getParentFile().mkdirs();
        }
        try {
            boolean fileCreated = newFile.createNewFile();
            try (BufferedWriter writer = Files.newBufferedWriter(newFile.toPath(), new OpenOption[0]);){
                writer.write(content);
            }
            if (fileCreated || isReplace) {
                this.contents.put(name, content);
                this.lines.put(name, Editor.splitContentIntoLines(content));
                this.paths.put(name, newFilePath);
            }
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    public void removeFile(String name) {
        this.contents.remove(name);
        this.lines.remove(name);
        this.paths.get(name).toFile().delete();
        this.paths.remove(name);
    }

    public String getFileContent(String name) {
        return this.contents.get(name);
    }

    public List<String> getFileLines(String name) {
        return this.lines.get(name);
    }

    public String getFileLine(String name, int line) {
        return this.lines.get(name).get(line);
    }

    public Position insertBlankLine(String fileName, int line, boolean indented) {
        if (!indented) {
            return this.insertBlankLineWithIndent(fileName, line, 0);
        }
        int indentAmount = Utils.getIndent(this.lines.get(fileName).get(line)).length();
        return this.insertBlankLineWithIndent(fileName, line, indentAmount);
    }

    public Position insertBlankLineWithIndent(String fileName, int line, int indentAmount) {
        String indentation = IntStream.range(0, indentAmount).mapToObj(ignored -> " ").collect(Collectors.joining());
        this.lines.get(fileName).add(line, indentation);
        this.contents.put(fileName, Editor.joinLinesIntoContent(this.lines.get(fileName)));
        return new Position(line, indentation.length());
    }

    public void replace(String fileName, Position start, Position end, String newContent) {
        this.replaceWithIndentedContent(fileName, start, end, newContent, 0);
    }

    public void replaceWithIndentedContent(String fileName, Position start, Position end, String newContent, int newLineIndent) {
        int i;
        String indent = IntStream.range(0, newLineIndent).mapToObj(ignored -> " ").collect(Collectors.joining());
        StringBuilder stringBuilder = new StringBuilder(4096);
        List<String> lineContent = this.lines.get(fileName);
        for (int i2 = 0; i2 != start.getLine(); ++i2) {
            Utils.writeLine(stringBuilder, lineContent.get(i2));
        }
        stringBuilder.append(lineContent.get(start.getLine()), 0, start.getCharacter());
        List<String> replacementLineContent = Editor.splitContentIntoLines(newContent);
        if (replacementLineContent.size() > 0) {
            for (i = 0; i != replacementLineContent.size() - 1; ++i) {
                if (i > 0) {
                    stringBuilder.append(indent);
                }
                Utils.writeLine(stringBuilder, replacementLineContent.get(i));
            }
            stringBuilder.append(indent).append(replacementLineContent.get(replacementLineContent.size() - 1));
        }
        Utils.writeLine(stringBuilder, lineContent.get(end.getLine()).substring(end.getCharacter()));
        for (i = end.getLine() + 1; i != lineContent.size(); ++i) {
            Utils.writeLine(stringBuilder, lineContent.get(i));
        }
        this.contents.put(fileName, stringBuilder.toString());
        this.lines.put(fileName, Editor.splitContentIntoLines(this.contents.get(fileName)));
        try (BufferedWriter fileWriter = Files.newBufferedWriter(this.paths.get(fileName), new OpenOption[0]);){
            fileWriter.write(this.contents.get(fileName));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void renameFile(String fileName, String newName) {
        this.contents.put(newName, this.contents.remove(fileName));
        this.lines.put(newName, this.lines.remove(fileName));
        Path path = this.paths.remove(fileName);
        Path newPath = Paths.get(this.rootDir.toString(), newName);
        path.toFile().renameTo(newPath.toFile());
        this.paths.put(newName, newPath);
    }

    public List<Range> searchText(String fileName, String text) {
        if (!this.lines.containsKey(fileName)) {
            return null;
        }
        ArrayList<Range> occurrences = new ArrayList<Range>();
        for (int i = 0; i != this.lines.get(fileName).size(); ++i) {
            String line = this.lines.get(fileName).get(i);
            if (!line.contains(text)) continue;
            int start = line.indexOf(text);
            while (start != -1) {
                int end = start + text.length();
                occurrences.add(new Range(new Position(i, start), new Position(i, end)));
                start = line.indexOf(text, end);
            }
        }
        return occurrences;
    }

    public Range searchTextFirstOccurrence(String fileName, String text) {
        List<Range> ranges = this.searchText(fileName, text);
        if (ranges != null && !ranges.isEmpty()) {
            return ranges.get(0);
        }
        return null;
    }

    public String getTextInRange(String fileName, Range range, String delimiter) {
        return this.getTextInRange(fileName, range, delimiter, str -> str);
    }

    public String getTextInRange(String fileName, Range range, String delimiter, Function<String, String> lineCleaner) {
        StringBuilder stringBuilder = new StringBuilder(4096);
        for (int line = range.getStart().getLine(); line <= range.getEnd().getLine(); ++line) {
            String lineContent = this.getFileLine(fileName, line);
            int truncateIndex = 0;
            if (line == range.getStart().getLine()) {
                lineContent = lineContent.substring(range.getStart().getCharacter());
                truncateIndex = range.getStart().getCharacter();
            }
            if (line == range.getEnd().getLine()) {
                lineContent = lineContent.substring(0, range.getEnd().getCharacter() - truncateIndex);
            }
            if (lineCleaner != null) {
                lineContent = lineCleaner.apply(lineContent);
            }
            if (delimiter == null) {
                Utils.writeLine(stringBuilder, lineContent);
                continue;
            }
            if (stringBuilder.length() == 0) {
                stringBuilder.append(lineContent);
                continue;
            }
            stringBuilder.append(delimiter).append(lineContent);
        }
        return stringBuilder.toString();
    }

    private static List<String> splitContentIntoLines(String content) {
        ArrayList<String> res = new ArrayList<String>();
        Scanner scanner = new Scanner(content);
        while (scanner.hasNextLine()) {
            res.add(scanner.nextLine());
        }
        if (content.endsWith("\n")) {
            res.add("");
        }
        return res;
    }

    private static String joinLinesIntoContent(List<String> lines) {
        return String.join((CharSequence)System.lineSeparator(), lines);
    }
}

