/*
 * Decompiled with CFR 0.152.
 */
package com.azure.autorest.customization;

import com.azure.autorest.customization.Editor;
import com.azure.autorest.customization.implementation.Utils;
import com.azure.autorest.customization.implementation.ls.EclipseLanguageClient;
import com.azure.autorest.customization.implementation.ls.models.FileChangeType;
import com.azure.autorest.customization.implementation.ls.models.FileEvent;
import com.azure.autorest.customization.models.Position;
import com.azure.autorest.customization.models.Range;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JavadocCustomization {
    private static final Pattern JAVADOC_LINE_CLEANER = Pattern.compile("^\\s*/?\\*{1,2}\\s?(.*?)(?:\\s*\\*/)?$");
    private static final Pattern EMPTY_JAVADOC_LINE_PATTERN = Pattern.compile("\\s*\\*/?\\s*");
    private static final Pattern THROWS_TAG = Pattern.compile(".*@throws ");
    private static final Pattern PARAM_TAG = Pattern.compile(".*@param ");
    private static final Pattern SPACE_THEN_ANYTHING = Pattern.compile(" .*");
    private static final Pattern JAVADOC_LINE_WITH_CONTENT = Pattern.compile("\\* .*$");
    private static final Pattern END_JAVADOC_LINE = Pattern.compile(" \\*/$");
    private static final Pattern JAVADOC_CONTENT = Pattern.compile(" +\\* ");
    private final EclipseLanguageClient languageClient;
    private final Editor editor;
    private final URI fileUri;
    private final String fileName;
    private final String indent;
    private String descriptionDocs;
    private final Map<String, String> paramDocs;
    private String returnDoc;
    private final Map<String, String> throwsDocs;
    private final List<String> seeDocs;
    private String sinceDoc;
    private String deprecatedDoc;
    private Range javadocRange;

    JavadocCustomization(Editor editor, EclipseLanguageClient languageClient, URI fileUri, String fileName, int symbolLine) {
        this.editor = editor;
        this.languageClient = languageClient;
        this.paramDocs = new LinkedHashMap<String, String>();
        this.throwsDocs = new LinkedHashMap<String, String>();
        this.seeDocs = new ArrayList<String>();
        this.fileUri = fileUri;
        this.fileName = fileName;
        this.indent = Utils.getIndent(editor.getFileLine(fileName, symbolLine));
        this.parseJavadoc(symbolLine);
    }

    Range getJavadocRange() {
        return this.javadocRange;
    }

    public JavadocCustomization replace(JavadocCustomization other) {
        this.descriptionDocs = other.descriptionDocs;
        this.paramDocs.clear();
        if (other.paramDocs != null) {
            this.paramDocs.putAll(other.paramDocs);
        }
        this.returnDoc = other.returnDoc;
        this.throwsDocs.clear();
        if (other.throwsDocs != null) {
            this.throwsDocs.putAll(other.throwsDocs);
        }
        this.seeDocs.clear();
        if (other.seeDocs != null) {
            this.seeDocs.addAll(other.seeDocs);
        }
        this.sinceDoc = other.sinceDoc;
        this.deprecatedDoc = other.deprecatedDoc;
        this.commit();
        return this;
    }

    public String getDescription() {
        return this.descriptionDocs;
    }

    public JavadocCustomization setDescription(String description) {
        return this.performChange(this.descriptionDocs, description, () -> {
            this.descriptionDocs = description;
        });
    }

    public Map<String, String> getParams() {
        return Collections.unmodifiableMap(this.paramDocs);
    }

    public JavadocCustomization setParam(String parameterName, String description) {
        return this.performChange(this.paramDocs.get(parameterName), description, () -> this.paramDocs.put(parameterName, description));
    }

    public JavadocCustomization removeParam(String parameterName) {
        this.paramDocs.remove(parameterName);
        this.commit();
        return this;
    }

    public String getReturn() {
        return this.returnDoc;
    }

    public JavadocCustomization setReturn(String description) {
        return this.performChange(this.returnDoc, description, () -> {
            this.returnDoc = description;
        });
    }

    public JavadocCustomization removeReturn() {
        return this.performChange(this.returnDoc, null, () -> {
            this.returnDoc = null;
        });
    }

    public Map<String, String> getThrows() {
        return Collections.unmodifiableMap(this.throwsDocs);
    }

    public JavadocCustomization addThrows(String exceptionType, String description) {
        return this.performChange(this.throwsDocs.get(exceptionType), description, () -> this.throwsDocs.put(exceptionType, description));
    }

    public JavadocCustomization removeThrows(String exceptionType) {
        this.throwsDocs.remove(exceptionType);
        this.commit();
        return this;
    }

    public List<String> getSees() {
        return Collections.unmodifiableList(this.seeDocs);
    }

    public JavadocCustomization addSee(String seeDoc) {
        this.seeDocs.add(seeDoc);
        this.commit();
        return this;
    }

    public String getSince() {
        return this.sinceDoc;
    }

    public JavadocCustomization setSince(String sinceDoc) {
        return this.performChange(this.sinceDoc, sinceDoc, () -> {
            this.sinceDoc = sinceDoc;
        });
    }

    public JavadocCustomization removeSince() {
        return this.performChange(this.sinceDoc, null, () -> {
            this.sinceDoc = null;
        });
    }

    public String getDeprecated() {
        return this.deprecatedDoc;
    }

    public JavadocCustomization setDeprecated(String deprecatedDoc) {
        return this.performChange(this.deprecatedDoc, deprecatedDoc, () -> {
            this.deprecatedDoc = deprecatedDoc;
        });
    }

    public JavadocCustomization removeDeprecated() {
        return this.performChange(this.deprecatedDoc, null, () -> {
            this.deprecatedDoc = null;
        });
    }

    private void initialize(int symbolLine) {
        this.editor.insertBlankLine(this.fileName, symbolLine++, false);
        this.editor.replace(this.fileName, new Position(symbolLine, 0), new Position(symbolLine, 0), this.indent);
        Position javadocCursor = new Position(symbolLine, this.indent.length());
        this.javadocRange = new Range(javadocCursor, javadocCursor);
        ++symbolLine;
        FileEvent blankLineEvent = new FileEvent();
        blankLineEvent.setUri(this.fileUri);
        blankLineEvent.setType(FileChangeType.CHANGED);
        this.languageClient.notifyWatchedFilesChanged(Collections.singletonList(blankLineEvent));
    }

    private void parseJavadoc(int symbolLine) {
        String lineContent = this.editor.getFileLine(this.fileName, --symbolLine);
        while (lineContent.startsWith(this.indent + "@")) {
            lineContent = this.editor.getFileLine(this.fileName, --symbolLine);
        }
        if (lineContent.endsWith("*/")) {
            Position javadocEnd = new Position(symbolLine, lineContent.length());
            int currentDocEndLine = symbolLine;
            while (!lineContent.contains("/*")) {
                Position docEnd;
                Position docStart;
                Position docEnd2;
                Position docStart2;
                if (lineContent.contains("@throws")) {
                    String type = THROWS_TAG.matcher(lineContent).replaceFirst("");
                    type = SPACE_THEN_ANYTHING.matcher(type).replaceFirst("");
                    docStart2 = new Position(symbolLine, lineContent.indexOf("@throws") + 8);
                    docEnd2 = new Position(currentDocEndLine, this.editor.getFileLine(this.fileName, currentDocEndLine).length());
                    this.throwsDocs.put(type, JavadocCustomization.readJavadocTextRange(this.editor, this.fileName, docStart2, docEnd2));
                    currentDocEndLine = symbolLine - 1;
                } else if (lineContent.contains("@return")) {
                    docStart = new Position(symbolLine, lineContent.indexOf("@return") + 8);
                    docEnd = new Position(currentDocEndLine, this.editor.getFileLine(this.fileName, currentDocEndLine).length());
                    this.returnDoc = JavadocCustomization.readJavadocTextRange(this.editor, this.fileName, docStart, docEnd);
                    currentDocEndLine = symbolLine - 1;
                } else if (lineContent.contains("@since")) {
                    docStart = new Position(symbolLine, lineContent.indexOf("@since") + 7);
                    docEnd = new Position(currentDocEndLine, this.editor.getFileLine(this.fileName, currentDocEndLine).length());
                    this.sinceDoc = JavadocCustomization.readJavadocTextRange(this.editor, this.fileName, docStart, docEnd);
                    currentDocEndLine = symbolLine - 1;
                } else if (lineContent.contains("@see")) {
                    docStart = new Position(symbolLine, lineContent.indexOf("@see") + 5);
                    docEnd = new Position(currentDocEndLine, this.editor.getFileLine(this.fileName, currentDocEndLine).length());
                    this.seeDocs.add(JavadocCustomization.readJavadocTextRange(this.editor, this.fileName, docStart, docEnd));
                    currentDocEndLine = symbolLine - 1;
                } else if (lineContent.contains("@deprecated")) {
                    docStart = new Position(symbolLine, lineContent.indexOf("@deprecated") + 5);
                    docEnd = new Position(currentDocEndLine, this.editor.getFileLine(this.fileName, currentDocEndLine).length());
                    this.deprecatedDoc = JavadocCustomization.readJavadocTextRange(this.editor, this.fileName, docStart, docEnd);
                    currentDocEndLine = symbolLine - 1;
                } else if (lineContent.contains("@param")) {
                    String name = PARAM_TAG.matcher(lineContent).replaceFirst("");
                    name = SPACE_THEN_ANYTHING.matcher(name).replaceFirst("");
                    docStart2 = new Position(symbolLine, lineContent.indexOf("@param") + 8 + name.length());
                    docEnd2 = new Position(currentDocEndLine, this.editor.getFileLine(this.fileName, currentDocEndLine).length());
                    this.paramDocs.put(name, JavadocCustomization.readJavadocTextRange(this.editor, this.fileName, docStart2, docEnd2));
                    currentDocEndLine = symbolLine - 1;
                } else if (EMPTY_JAVADOC_LINE_PATTERN.matcher(lineContent).matches()) {
                    --currentDocEndLine;
                }
                lineContent = this.editor.getFileLine(this.fileName, --symbolLine);
            }
            Position javadocStart = new Position(symbolLine, this.indent.length());
            this.javadocRange = new Range(javadocStart, javadocEnd);
            if (lineContent.endsWith("/*") || lineContent.endsWith("/**")) {
                ++symbolLine;
            }
            Position descriptionStart = new Position(symbolLine, JAVADOC_LINE_WITH_CONTENT.matcher(this.editor.getFileLine(this.fileName, symbolLine)).replaceFirst("").length() + 2);
            String descriptionEndLineContent = this.editor.getFileLine(this.fileName, currentDocEndLine);
            while (descriptionEndLineContent.trim().endsWith("*")) {
                descriptionEndLineContent = this.editor.getFileLine(this.fileName, --currentDocEndLine);
            }
            Position descriptionEnd = new Position(currentDocEndLine, END_JAVADOC_LINE.matcher(descriptionEndLineContent).replaceFirst("").length());
            this.descriptionDocs = JAVADOC_CONTENT.matcher(this.editor.getTextInRange(this.fileName, new Range(descriptionStart, descriptionEnd), " ")).replaceAll(" ").trim();
        } else {
            this.initialize(symbolLine);
        }
    }

    private static String readJavadocTextRange(Editor editor, String fileName, Position docStart, Position docEnd) {
        return editor.getTextInRange(fileName, new Range(docStart, docEnd), " ", line -> {
            Matcher lineCleaningMatch = JAVADOC_LINE_CLEANER.matcher((CharSequence)line);
            return lineCleaningMatch.find() ? lineCleaningMatch.group(1) : line;
        }).trim();
    }

    private void commit() {
        StringBuilder stringBuilder = new StringBuilder(4096);
        Utils.writeLine(stringBuilder, "/**");
        if (this.descriptionDocs != null) {
            Utils.writeLine(stringBuilder.append(this.indent).append(" * "), this.descriptionDocs);
        }
        if (!this.paramDocs.isEmpty() || !this.throwsDocs.isEmpty() || this.returnDoc != null || this.deprecatedDoc != null) {
            Utils.writeLine(stringBuilder.append(this.indent), " * ");
            for (Map.Entry<String, String> paramDoc : this.paramDocs.entrySet()) {
                Utils.writeLine(stringBuilder.append(this.indent).append(" * @param ").append(paramDoc.getKey()).append(" "), paramDoc.getValue());
            }
            if (this.returnDoc != null) {
                Utils.writeLine(stringBuilder.append(this.indent).append(" * @return "), this.returnDoc);
            }
            for (Map.Entry<String, String> throwsDoc : this.throwsDocs.entrySet()) {
                Utils.writeLine(stringBuilder.append(this.indent).append(" * @throws ").append(throwsDoc.getKey()).append(" "), throwsDoc.getValue());
            }
            for (String seeDoc : this.seeDocs) {
                Utils.writeLine(stringBuilder.append(this.indent).append(" * @see "), seeDoc);
            }
            if (this.sinceDoc != null) {
                Utils.writeLine(stringBuilder.append(this.indent).append(" * @since "), this.sinceDoc);
            }
            if (this.deprecatedDoc != null) {
                Utils.writeLine(stringBuilder.append(this.indent).append(" * @deprecated "), this.deprecatedDoc);
            }
        }
        stringBuilder.append(this.indent).append(" */");
        this.editor.replace(this.fileName, this.javadocRange.getStart(), this.javadocRange.getEnd(), stringBuilder.toString());
        FileEvent replaceEvent = new FileEvent();
        replaceEvent.setUri(this.fileUri);
        replaceEvent.setType(FileChangeType.CHANGED);
        this.languageClient.notifyWatchedFilesChanged(Collections.singletonList(replaceEvent));
        int javadocStartLine = this.javadocRange.getStart().getLine();
        String lineContent = this.editor.getFileLine(this.fileName, javadocStartLine);
        while (!lineContent.endsWith("*/")) {
            lineContent = this.editor.getFileLine(this.fileName, ++javadocStartLine);
        }
        this.parseJavadoc(javadocStartLine + 1);
    }

    private JavadocCustomization performChange(String oldValue, String newValue, Runnable changePerformer) {
        if (!Objects.equals(oldValue, newValue)) {
            changePerformer.run();
            this.commit();
        }
        return this;
    }
}

