/*
 * Decompiled with CFR 0.152.
 */
package com.azure.autorest.customization;

import com.azure.autorest.customization.ClassCustomization;
import com.azure.autorest.customization.Editor;
import com.azure.autorest.customization.PackageCustomization;
import com.azure.autorest.customization.implementation.Utils;
import com.azure.autorest.customization.implementation.ls.EclipseLanguageClient;
import com.azure.autorest.customization.implementation.ls.models.SymbolInformation;
import java.util.Optional;

public final class LibraryCustomization {
    private EclipseLanguageClient languageClient;
    private Editor editor;

    LibraryCustomization(Editor editor, EclipseLanguageClient languageClient) {
        this.editor = editor;
        this.languageClient = languageClient;
    }

    public PackageCustomization getPackage(String packageName) {
        return new PackageCustomization(this.editor, this.languageClient, packageName);
    }

    public ClassCustomization getClass(String packageName, String className) {
        String packagePath = packageName.replace(".", "/");
        Optional<SymbolInformation> classSymbol = this.languageClient.findWorkspaceSymbol(className).stream().filter(si -> si.getName().equals(className)).filter(si -> si.getLocation().getUri().toString().endsWith(packagePath + "/" + className + ".java")).findFirst();
        return Utils.returnIfPresentOrThrow(classSymbol, symbol -> new ClassCustomization(this.editor, this.languageClient, packageName, className, (SymbolInformation)symbol), () -> new IllegalArgumentException(className + " does not exist in package " + packageName));
    }

    public Editor getRawEditor() {
        return this.editor;
    }
}

