/*
 * Decompiled with CFR 0.152.
 */
package com.azure.autorest.customization;

import com.azure.autorest.customization.ClassCustomization;
import com.azure.autorest.customization.Editor;
import com.azure.autorest.customization.implementation.Utils;
import com.azure.autorest.customization.implementation.ls.EclipseLanguageClient;
import com.azure.autorest.customization.implementation.ls.models.SymbolInformation;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class PackageCustomization {
    private final EclipseLanguageClient languageClient;
    private final Editor editor;
    private final String packageName;

    PackageCustomization(Editor editor, EclipseLanguageClient languageClient, String packageName) {
        this.editor = editor;
        this.languageClient = languageClient;
        this.packageName = packageName;
    }

    public ClassCustomization getClass(String className) {
        String packagePath = this.packageName.replace(".", "/");
        Optional<SymbolInformation> classSymbol = this.languageClient.findWorkspaceSymbol(className).stream().filter(si -> si.getName().equals(className)).filter(si -> si.getLocation().getUri().toString().endsWith(packagePath + "/" + className + ".java")).findFirst();
        return Utils.returnIfPresentOrThrow(classSymbol, symbol -> new ClassCustomization(this.editor, this.languageClient, this.packageName, className, (SymbolInformation)symbol), () -> new IllegalArgumentException(className + " does not exist in package " + this.packageName));
    }

    public List<ClassCustomization> listClasses() {
        List<ClassCustomization> classCustomizations = this.languageClient.findWorkspaceSymbol("*").stream().filter(si -> si.getContainerName().equals(this.packageName)).map(classSymbol -> new ClassCustomization(this.editor, this.languageClient, this.packageName, classSymbol.getName(), (SymbolInformation)classSymbol)).collect(Collectors.toList());
        return classCustomizations;
    }
}

