/*
 * Decompiled with CFR 0.152.
 */
package com.azure.autorest.customization;

import com.azure.autorest.customization.CodeCustomization;
import com.azure.autorest.customization.Editor;
import com.azure.autorest.customization.PackageCustomization;
import com.azure.autorest.customization.implementation.Utils;
import com.azure.autorest.customization.implementation.ls.EclipseLanguageClient;
import com.azure.autorest.customization.implementation.ls.models.CodeAction;
import com.azure.autorest.customization.implementation.ls.models.JavaCodeActionKind;
import com.azure.autorest.customization.implementation.ls.models.SymbolInformation;
import com.azure.autorest.customization.implementation.ls.models.SymbolKind;
import com.azure.autorest.customization.implementation.ls.models.TextEdit;
import com.azure.autorest.customization.implementation.ls.models.WorkspaceEdit;
import com.azure.autorest.customization.implementation.ls.models.WorkspaceEditCommand;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class PropertyCustomization
extends CodeCustomization {
    private static final Pattern METHOD_PARAMS_CAPTURE = Pattern.compile("\\(.*\\)");
    private final String packageName;
    private final String className;
    private final String propertyName;

    PropertyCustomization(Editor editor, EclipseLanguageClient languageClient, String packageName, String className, SymbolInformation symbol, String propertyName) {
        super(editor, languageClient, symbol);
        this.packageName = packageName;
        this.className = className;
        this.propertyName = propertyName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public PropertyCustomization rename(String newName) {
        List symbols = this.languageClient.listDocumentSymbols(this.fileUri).stream().filter(si -> si.getName().toLowerCase().contains(this.propertyName.toLowerCase())).collect(Collectors.toList());
        String propertyPascalName = this.propertyName.substring(0, 1).toUpperCase() + this.propertyName.substring(1);
        String newPascalName = newName.substring(0, 1).toUpperCase() + newName.substring(1);
        for (SymbolInformation symbol : symbols) {
            if (symbol.getKind() == SymbolKind.FIELD) {
                WorkspaceEdit edit = this.languageClient.renameSymbol(this.fileUri, symbol.getLocation().getRange().getStart(), newName);
                Utils.applyWorkspaceEdit(edit, this.editor, this.languageClient);
                continue;
            }
            if (symbol.getKind() != SymbolKind.METHOD) continue;
            String methodName = symbol.getName().replace(propertyPascalName, newPascalName).replace(this.propertyName, newName);
            methodName = METHOD_PARAMS_CAPTURE.matcher(methodName).replaceFirst("");
            WorkspaceEdit edit = this.languageClient.renameSymbol(this.fileUri, symbol.getLocation().getRange().getStart(), methodName);
            Utils.applyWorkspaceEdit(edit, this.editor, this.languageClient);
        }
        return this.refreshCustomization(newName);
    }

    public PropertyCustomization addAnnotation(String annotation) {
        return Utils.addAnnotation(annotation, this, () -> this.refreshCustomization(this.propertyName));
    }

    public PropertyCustomization removeAnnotation(String annotation) {
        return Utils.removeAnnotation(this, compilationUnit -> ((FieldDeclaration)((ClassOrInterfaceDeclaration)compilationUnit.getClassByName(this.className).get()).getFieldByName(this.propertyName).get()).getAnnotationByName(Utils.cleanAnnotationName(annotation)), () -> this.refreshCustomization(this.propertyName));
    }

    public PropertyCustomization generateGetterAndSetter() {
        Optional<CodeAction> generateAccessors = this.languageClient.listCodeActions(this.fileUri, this.symbol.getLocation().getRange()).stream().filter(ca -> ca.getKind().equals(JavaCodeActionKind.SOURCE_GENERATE_ACCESSORS.toString())).findFirst();
        if (generateAccessors.isPresent() && generateAccessors.get().getCommand() instanceof WorkspaceEditCommand) {
            WorkspaceEditCommand command = (WorkspaceEditCommand)generateAccessors.get().getCommand();
            for (WorkspaceEdit workspaceEdit : command.getArguments()) {
                Utils.applyWorkspaceEdit(workspaceEdit, this.editor, this.languageClient);
            }
            List<TextEdit> formats = this.languageClient.format(this.fileUri);
            Utils.applyTextEdits(this.fileUri, formats, this.editor, this.languageClient);
            String setterMethod = "set" + this.propertyName.substring(0, 1).toUpperCase() + this.propertyName.substring(1);
            new PackageCustomization(this.editor, this.languageClient, this.packageName).getClass(this.className).getMethod(setterMethod).setReturnType(this.className, "this");
        }
        return this;
    }

    public PropertyCustomization setModifier(int modifiers) {
        String target = " *(?:(?:public|protected|private|static|final|transient|volatile) ?)*(.* )";
        this.languageClient.listDocumentSymbols(this.symbol.getLocation().getUri()).stream().filter(si -> si.getName().equals(this.propertyName) && si.getKind() == SymbolKind.FIELD).findFirst().ifPresent(symbolInformation -> Utils.replaceModifier(symbolInformation, this.editor, this.languageClient, target + this.propertyName, "$1" + this.propertyName, Modifier.fieldModifiers(), modifiers));
        return this.refreshCustomization(this.propertyName);
    }

    private PropertyCustomization refreshCustomization(String propertyName) {
        return new PackageCustomization(this.editor, this.languageClient, this.packageName).getClass(this.className).getProperty(propertyName);
    }
}

