/*
 * Decompiled with CFR 0.152.
 */
package com.azure.autorest.customization.implementation;

import com.azure.autorest.customization.ClassCustomization;
import com.azure.autorest.customization.CodeCustomization;
import com.azure.autorest.customization.Editor;
import com.azure.autorest.customization.implementation.ls.EclipseLanguageClient;
import com.azure.autorest.customization.implementation.ls.models.CodeActionKind;
import com.azure.autorest.customization.implementation.ls.models.FileChangeType;
import com.azure.autorest.customization.implementation.ls.models.FileEvent;
import com.azure.autorest.customization.implementation.ls.models.SymbolInformation;
import com.azure.autorest.customization.implementation.ls.models.TextEdit;
import com.azure.autorest.customization.implementation.ls.models.WorkspaceEdit;
import com.azure.autorest.customization.implementation.ls.models.WorkspaceEditCommand;
import com.azure.autorest.customization.models.Position;
import com.github.javaparser.Range;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.expr.AnnotationExpr;
import java.io.File;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Utils {
    public static final Pattern SINGLE_LINE_JAVADOC_PATTERN = Pattern.compile("^\\s*\\/\\*\\*(.*?)\\*\\/\\s*$");
    public static final Pattern JAVADOC_START_PATTERN = Pattern.compile("^\\s*\\/\\*\\*\\s*$");
    public static final Pattern JAVADOC_END_PATTERN = Pattern.compile("^\\s*\\*\\/\\s*$");
    public static final Pattern INDENT_DETERMINATION_PATTERN = Pattern.compile("^(\\s*).*$");
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("package\\s[\\w\\.]+;");
    private static final Pattern IMPORT_PATTERN = Pattern.compile("import\\s(?:static\\s)?[\\w\\.]+;");
    public static final Pattern ANYTHING_THEN_SPACE_PATTERN = Pattern.compile(".* ");
    private static final Pattern BEGINNING_OF_PARAMETERS_PATTERN = Pattern.compile("^(\\s*(?:([\\w\\s]*?)\\s)?(?:([a-zA-Z$_][\\w]*?)\\s+)?([a-zA-Z$_][\\w]*?)\\s*)\\(.*$");
    private static final Pattern ENDING_OF_PARAMETERS_PATTERN = Pattern.compile("^(.*)\\)\\s*\\{.*$");

    public static void applyWorkspaceEdit(WorkspaceEdit workspaceEdit, Editor editor, EclipseLanguageClient languageClient) {
        ArrayList<FileEvent> changes = new ArrayList<FileEvent>();
        for (Map.Entry<URI, List<TextEdit>> edit : workspaceEdit.getChanges().entrySet()) {
            int i = edit.getKey().toString().indexOf("src/main/java/");
            String fileName = edit.getKey().toString().substring(i);
            if (!editor.getContents().containsKey(fileName)) continue;
            for (TextEdit textEdit : edit.getValue()) {
                editor.replace(fileName, textEdit.getRange().getStart(), textEdit.getRange().getEnd(), textEdit.getNewText());
            }
            FileEvent fileEvent = new FileEvent();
            fileEvent.setUri(edit.getKey());
            fileEvent.setType(FileChangeType.CHANGED);
            changes.add(fileEvent);
        }
        languageClient.notifyWatchedFilesChanged(changes);
    }

    public static void applyTextEdits(URI fileUri, List<TextEdit> textEdits, Editor editor, EclipseLanguageClient languageClient) {
        ArrayList<FileEvent> changes = new ArrayList<FileEvent>();
        int i = fileUri.toString().indexOf("src/main/java/");
        String fileName = fileUri.toString().substring(i);
        if (editor.getContents().containsKey(fileName)) {
            for (int j = textEdits.size() - 1; j >= 0; --j) {
                TextEdit textEdit = textEdits.get(j);
                editor.replace(fileName, textEdit.getRange().getStart(), textEdit.getRange().getEnd(), textEdit.getNewText());
            }
            FileEvent fileEvent = new FileEvent();
            fileEvent.setUri(fileUri);
            fileEvent.setType(FileChangeType.CHANGED);
            changes.add(fileEvent);
        }
        languageClient.notifyWatchedFilesChanged(changes);
    }

    public static void deleteDirectory(File directoryToBeDeleted) {
        File[] allContents = directoryToBeDeleted.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                Utils.deleteDirectory(file);
            }
        }
        directoryToBeDeleted.delete();
    }

    public static boolean isNullOrEmpty(CharSequence charSequence) {
        return charSequence == null || charSequence.length() == 0;
    }

    public static <T> boolean isNullOrEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static <T> boolean isNullOrEmpty(Iterable<T> iterable) {
        return iterable == null || !iterable.iterator().hasNext();
    }

    static void validateModifiers(int validTypeModifiers, int newModifiers) {
        if (newModifiers == 0) {
            return;
        }
        if (newModifiers < 0) {
            throw new IllegalArgumentException("Modifiers aren't allowed to be less than or equal to 0.");
        }
        if (validTypeModifiers != (validTypeModifiers | newModifiers)) {
            throw new IllegalArgumentException("Modifiers contain illegal modifiers for the type.");
        }
    }

    public static void replaceModifier(SymbolInformation symbol, Editor editor, EclipseLanguageClient languageClient, String replaceTarget, String modifierReplaceBase, int validaTypeModifiers, int newModifiers) {
        Utils.validateModifiers(validaTypeModifiers, newModifiers);
        URI fileUri = symbol.getLocation().getUri();
        int i = fileUri.toString().indexOf("src/main/java/");
        String fileName = fileUri.toString().substring(i);
        int line = symbol.getLocation().getRange().getStart().getLine();
        Position start = new Position(line, 0);
        String oldLineContent = editor.getFileLine(fileName, line);
        Position end = new Position(line, oldLineContent.length());
        String newModifiersString = Modifier.toString(newModifiers);
        String newLineContent = Utils.isNullOrEmpty(newModifiersString) ? oldLineContent.replaceFirst(replaceTarget, modifierReplaceBase) : oldLineContent.replaceFirst(replaceTarget, newModifiersString + " " + modifierReplaceBase);
        TextEdit textEdit = new TextEdit();
        textEdit.setNewText(newLineContent);
        textEdit.setRange(new com.azure.autorest.customization.models.Range(start, end));
        WorkspaceEdit workspaceEdit = new WorkspaceEdit();
        workspaceEdit.setChanges(Collections.singletonMap(fileUri, Collections.singletonList(textEdit)));
        Utils.applyWorkspaceEdit(workspaceEdit, editor, languageClient);
    }

    public static <T, S> S returnIfPresentOrThrow(Optional<T> optional, Function<T, S> returnFormatter, Supplier<RuntimeException> orThrow) {
        if (optional.isPresent()) {
            return returnFormatter.apply(optional.get());
        }
        throw orThrow.get();
    }

    public static <T, S> S returnIfPresentOrElse(Optional<T> optional, Function<T, S> returnFormatter, Supplier<S> orElse) {
        return optional.isPresent() ? returnFormatter.apply(optional.get()) : orElse.get();
    }

    public static void writeLine(StringBuilder stringBuilder, String text) {
        stringBuilder.append(text).append(System.lineSeparator());
    }

    public static int walkDownFileUntilLineMatches(Editor editor, String fileName, int startLine, Predicate<String> linePredicate) {
        return Utils.walkFileUntilLineMatches(editor, fileName, startLine, linePredicate, true);
    }

    public static int walkUpFileUntilLineMatches(Editor editor, String fileName, int startLine, Predicate<String> linePredicate) {
        return Utils.walkFileUntilLineMatches(editor, fileName, startLine, linePredicate, false);
    }

    private static int walkFileUntilLineMatches(Editor editor, String fileName, int startLine, Predicate<String> linePredicate, boolean isWalkingDown) {
        int matchingLine = -1;
        List<String> fileLines = editor.getFileLines(fileName);
        if (isWalkingDown) {
            for (int line = startLine; line < fileLines.size(); ++line) {
                if (!linePredicate.test(fileLines.get(line))) continue;
                matchingLine = line;
                break;
            }
        } else {
            for (int line = startLine; line >= 0; --line) {
                if (!linePredicate.test(fileLines.get(line))) continue;
                matchingLine = line;
                break;
            }
        }
        return matchingLine;
    }

    public static <T extends CodeCustomization> T addAnnotation(String annotation, CodeCustomization customization, Supplier<T> refreshedCustomizationSupplier) {
        SymbolInformation symbol = customization.getSymbol();
        Editor editor = customization.getEditor();
        String fileName = customization.getFileName();
        URI fileUri = customization.getFileUri();
        EclipseLanguageClient languageClient = customization.getLanguageClient();
        if (!((String)annotation).startsWith("@")) {
            annotation = "@" + (String)annotation;
        }
        if (editor.getContents().containsKey(fileName)) {
            int line = symbol.getLocation().getRange().getStart().getLine();
            Position position = editor.insertBlankLine(fileName, line, true);
            editor.replace(fileName, position, position, (String)annotation);
            FileEvent fileEvent = new FileEvent();
            fileEvent.setUri(fileUri);
            fileEvent.setType(FileChangeType.CHANGED);
            languageClient.notifyWatchedFilesChanged(Collections.singletonList(fileEvent));
            Utils.organizeImportsOnRange(languageClient, editor, fileUri, symbol.getLocation().getRange());
        }
        return (T)((CodeCustomization)refreshedCustomizationSupplier.get());
    }

    public static String cleanAnnotationName(String annotationName) {
        return annotationName.startsWith("@") ? annotationName.substring(1) : annotationName;
    }

    public static <T extends CodeCustomization> T removeAnnotation(T codeCustomization, Function<CompilationUnit, Optional<AnnotationExpr>> annotationRetriever, Supplier<T> refreshedCustomizationSupplier) {
        String fileName;
        Editor editor = codeCustomization.getEditor();
        CompilationUnit compilationUnit = StaticJavaParser.parse((String)editor.getFileContent(fileName = codeCustomization.getFileName()));
        Optional<AnnotationExpr> potentialAnnotation = annotationRetriever.apply(compilationUnit);
        if (potentialAnnotation.isPresent()) {
            potentialAnnotation.get().remove();
            editor.replaceFile(fileName, compilationUnit.toString());
            Utils.sendFilesChangeNotification(codeCustomization.getLanguageClient(), codeCustomization.getFileUri());
            return (T)((CodeCustomization)refreshedCustomizationSupplier.get());
        }
        return codeCustomization;
    }

    public static void sendFilesChangeNotification(EclipseLanguageClient languageClient, URI fileUri) {
        FileEvent fileEvent = new FileEvent();
        fileEvent.setUri(fileUri);
        fileEvent.setType(FileChangeType.CHANGED);
        languageClient.notifyWatchedFilesChanged(Collections.singletonList(fileEvent));
    }

    public static boolean declarationContainsSymbol(Range declarationRange, com.azure.autorest.customization.models.Range symbolRange) {
        return declarationRange.begin.line <= symbolRange.getStart().getLine() && declarationRange.end.line >= symbolRange.getStart().getLine();
    }

    public static <T extends CodeCustomization> T replaceBody(String newBody, CodeCustomization customization, Supplier<T> refreshedCustomizationSupplier) {
        SymbolInformation symbol = customization.getSymbol();
        Editor editor = customization.getEditor();
        String fileName = customization.getFileName();
        int line = symbol.getLocation().getRange().getStart().getLine();
        String methodBlockIndent = Utils.getIndent(editor.getFileLine(fileName, line));
        Pattern startPattern = Pattern.compile(".*\\{\\s*");
        int startLine = Utils.walkDownFileUntilLineMatches(editor, fileName, line, lineContent -> startPattern.matcher((CharSequence)lineContent).matches()) + 1;
        String methodContentIndent = Utils.getIndent(editor.getFileLine(fileName, startLine));
        Position oldBodyStart = new Position(startLine, methodContentIndent.length());
        Pattern closePattern = Pattern.compile(methodBlockIndent + "}\\s*");
        int lastLine = Utils.walkDownFileUntilLineMatches(editor, fileName, startLine, lineContent -> closePattern.matcher((CharSequence)lineContent).matches()) - 1;
        Position oldBodyEnd = new Position(lastLine, editor.getFileLine(fileName, lastLine).length());
        editor.replaceWithIndentedContent(fileName, oldBodyStart, oldBodyEnd, newBody, methodContentIndent.length());
        FileEvent fileEvent = new FileEvent();
        fileEvent.setUri(customization.getFileUri());
        fileEvent.setType(FileChangeType.CHANGED);
        customization.getLanguageClient().notifyWatchedFilesChanged(Collections.singletonList(fileEvent));
        return (T)((CodeCustomization)refreshedCustomizationSupplier.get());
    }

    public static <T extends CodeCustomization> T replaceParameters(String newParameters, CodeCustomization customization, Supplier<T> refreshCustomizationSupplier) {
        SymbolInformation symbol = customization.getSymbol();
        Editor editor = customization.getEditor();
        String fileName = customization.getFileName();
        URI fileUri = customization.getFileUri();
        EclipseLanguageClient languageClient = customization.getLanguageClient();
        int line = symbol.getLocation().getRange().getStart().getLine();
        Matcher matcher = BEGINNING_OF_PARAMETERS_PATTERN.matcher(editor.getFileLine(fileName, line));
        while (!matcher.matches()) {
            matcher = BEGINNING_OF_PARAMETERS_PATTERN.matcher(editor.getFileLine(fileName, ++line));
        }
        Position parametersStart = new Position(line, matcher.group(1).length() + 1);
        matcher = ENDING_OF_PARAMETERS_PATTERN.matcher(editor.getFileLine(fileName, line));
        while (!matcher.matches()) {
            matcher = ENDING_OF_PARAMETERS_PATTERN.matcher(editor.getFileLine(fileName, ++line));
        }
        Position parametersEnd = new Position(line, matcher.group(1).length());
        editor.replace(fileName, parametersStart, parametersEnd, newParameters);
        FileEvent fileEvent = new FileEvent();
        fileEvent.setUri(fileUri);
        fileEvent.setType(FileChangeType.CHANGED);
        languageClient.notifyWatchedFilesChanged(Collections.singletonList(fileEvent));
        return (T)((CodeCustomization)refreshCustomizationSupplier.get());
    }

    public static String getIndent(String content) {
        Matcher matcher = INDENT_DETERMINATION_PATTERN.matcher(content);
        return matcher.matches() ? matcher.group(1) : "";
    }

    public static <T extends CodeCustomization> T addImports(List<String> importsToAdd, ClassCustomization customization, Supplier<T> refreshCustomizationSupplier) {
        ClassCustomization codeCustomization = customization;
        EclipseLanguageClient languageClient = codeCustomization.getLanguageClient();
        Editor editor = codeCustomization.getEditor();
        URI fileUri = codeCustomization.getFileUri();
        String fileName = codeCustomization.getFileName();
        if (!Utils.isNullOrEmpty(importsToAdd)) {
            int importLine = Utils.walkDownFileUntilLineMatches(editor, fileName, 0, line -> PACKAGE_PATTERN.matcher((CharSequence)line).matches()) + 1;
            Position importPosition = new Position(importLine, 0);
            String imports = importsToAdd.stream().map(importToAdd -> "import " + importToAdd + ";").collect(Collectors.joining("\n"));
            editor.insertBlankLine(fileName, importLine, false);
            editor.replace(fileName, importPosition, importPosition, imports);
        }
        FileEvent fileEvent = new FileEvent();
        fileEvent.setUri(fileUri);
        fileEvent.setType(FileChangeType.CHANGED);
        languageClient.notifyWatchedFilesChanged(Collections.singletonList(fileEvent));
        return (T)((CodeCustomization)refreshCustomizationSupplier.get());
    }

    public static void organizeImportsOnRange(EclipseLanguageClient languageClient, Editor editor, URI fileUri, com.azure.autorest.customization.models.Range range) {
        languageClient.listCodeActions(fileUri, range).stream().filter(ca -> ca.getKind().equals(CodeActionKind.SOURCE_ORGANIZEIMPORTS.toString())).findFirst().ifPresent(action -> {
            if (action.getCommand() instanceof WorkspaceEditCommand) {
                ((WorkspaceEditCommand)action.getCommand()).getArguments().forEach(importEdit -> Utils.applyWorkspaceEdit(importEdit, editor, languageClient));
            }
        });
    }

    public static boolean isWindows() {
        String osName = System.getProperty("os.name");
        return osName != null && osName.startsWith("Windows");
    }

    public static boolean isMac() {
        String osName = System.getProperty("os.name");
        return osName != null && (osName.startsWith("Mac") || osName.startsWith("Darwin"));
    }

    private Utils() {
    }
}

