/*
 * Decompiled with CFR 0.152.
 */
package com.azure.autorest.customization.implementation.ls;

import com.azure.autorest.customization.implementation.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.GZIPInputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;

public class EclipseLanguageServerFacade {
    private final Process server;

    public EclipseLanguageServerFacade(int port) {
        this(null, port);
    }

    public EclipseLanguageServerFacade(String pathToLanguageServerPlugin, int port) {
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutdown));
        try {
            Path languageServerPath = pathToLanguageServerPlugin == null ? EclipseLanguageServerFacade.getLanguageServerDirectory() : Paths.get(pathToLanguageServerPlugin, new String[0]).resolve("jdt-language-server");
            Object command = "java -agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=1044 -Declipse.application=org.eclipse.jdt.ls.core.id1 -Dosgi.bundles.defaultStartLevel=4 -Declipse.product=org.eclipse.jdt.ls.core.product -Dlog.protocol=true -Dlog.level=ALL -noverify -Xmx1G -jar ./plugins/org.eclipse.equinox.launcher_1.6.400.v20210924-0641.jar ";
            double version = Double.parseDouble(System.getProperty("java.specification.version"));
            if (version >= 9.0) {
                command = (String)command + "--add-modules=ALL-SYSTEM --add-opens java.base/java.util=ALL-UNNAMED --add-opens java.base/java.lang=ALL-UNNAMED ";
            }
            command = Utils.isWindows() ? (String)command + "-configuration ./config_win" : (Utils.isMac() ? (String)command + "-configuration ./config_mac" : (String)command + "-configuration ./config_linux");
            this.server = Runtime.getRuntime().exec((String)command, new String[]{"CLIENT_PORT=" + port}, languageServerPath.toFile());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Path getLanguageServerDirectory() throws IOException {
        Path languageServerPath;
        URL downloadUrl;
        Path tmp = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
        Path autorestLanguageServer = tmp.resolve("autorest-java-language-server");
        int javaVersion = Runtime.version().feature();
        if (javaVersion < 17) {
            downloadUrl = URI.create("https://www.eclipse.org/downloads/download.php?file=/jdtls/milestones/1.12.0/jdt-language-server-1.12.0-202206011637.tar.gz").toURL();
            languageServerPath = autorestLanguageServer.resolve("1.12.0");
        } else {
            downloadUrl = URI.create("https://www.eclipse.org/downloads/download.php?file=/jdtls/milestones/1.29.0/jdt-language-server-1.29.0-202310261436.tar.gz").toURL();
            languageServerPath = autorestLanguageServer.resolve("1.29.0");
        }
        Path languageServer = languageServerPath.resolve("jdt-language-server");
        if (!Files.exists(languageServerPath, new LinkOption[0]) || !Files.exists(languageServer, new LinkOption[0])) {
            Files.createDirectories(languageServerPath, new FileAttribute[0]);
            Path zipPath = languageServerPath.resolve("jdt-language-server.tar.gz");
            try (InputStream in = downloadUrl.openStream();){
                Files.copy(in, zipPath, new CopyOption[0]);
            }
            return EclipseLanguageServerFacade.unzipLanguageServer(zipPath);
        }
        return languageServer;
    }

    private static Path unzipLanguageServer(Path zipPath) throws IOException {
        try (TarInputStream tar = new TarInputStream((InputStream)new GZIPInputStream(Files.newInputStream(zipPath, new OpenOption[0])));){
            TarEntry entry;
            Path languageServerDirectory = zipPath.getParent().resolve("jdt-language-server");
            Files.createDirectory(languageServerDirectory, new FileAttribute[0]);
            while ((entry = tar.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    Files.createDirectories(languageServerDirectory.resolve(entry.getName()), new FileAttribute[0]);
                    continue;
                }
                Files.copy((InputStream)tar, languageServerDirectory.resolve(entry.getName()), new CopyOption[0]);
            }
            Path path = languageServerDirectory;
            return path;
        }
    }

    public InputStream getOutput() {
        return this.server.getInputStream();
    }

    public void shutdown() {
        if (this.server != null && this.server.isAlive()) {
            this.server.destroy();
        }
    }
}

