/*
 * Decompiled with CFR 0.152.
 */
package com.azure.autorest.customization.implementation.ls.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum SymbolKind {
    FILE(1),
    MODULE(2),
    NAMESPACE(3),
    PACKAGE(4),
    CLASS(5),
    METHOD(6),
    PROPERTY(7),
    FIELD(8),
    CONSTRUCTOR(9),
    ENUM(10),
    INTERFACE(11),
    FUNCTION(12),
    VARIABLE(13),
    CONSTANT(14),
    STRING(15),
    NUMBER(16),
    BOOLEAN(17),
    ARRAY(18),
    OBJECT(19),
    KEY(20),
    NULL(21),
    ENUM_MEMBER(22),
    STRUCT(23),
    EVENT(24),
    OPERATOR(25),
    TYPE_PARAMETER(26);

    private static final SymbolKind[] INT_TO_KIND_MAP;
    private final int value;
    private final String valueString;

    private SymbolKind(int value) {
        this.value = value;
        this.valueString = Integer.toString(value);
    }

    @JsonCreator
    public static SymbolKind fromInt(int value) {
        return value < 0 || value >= INT_TO_KIND_MAP.length ? null : INT_TO_KIND_MAP[value];
    }

    @JsonValue
    public String toString() {
        return this.valueString;
    }

    static {
        INT_TO_KIND_MAP = new SymbolKind[27];
        SymbolKind[] symbolKindArray = SymbolKind.values();
        int n = symbolKindArray.length;
        for (int i = 0; i < n; ++i) {
            SymbolKind kind;
            SymbolKind.INT_TO_KIND_MAP[kind.value] = kind = symbolKindArray[i];
        }
    }
}

