/*
 * Decompiled with CFR 0.152.
 */
package com.azure.tools.codesnippetplugin.implementation;

import com.azure.tools.codesnippetplugin.ExecutionMode;
import com.azure.tools.codesnippetplugin.RootAndGlob;
import com.azure.tools.codesnippetplugin.implementation.Codesnippet;
import com.azure.tools.codesnippetplugin.implementation.CodesnippetError;
import com.azure.tools.codesnippetplugin.implementation.CodesnippetLengthError;
import com.azure.tools.codesnippetplugin.implementation.CodesnippetMismatchError;
import com.azure.tools.codesnippetplugin.implementation.CodesnippetMissingError;
import com.azure.tools.codesnippetplugin.implementation.SnippetDictionary;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public final class SnippetReplacer {
    private static final String JAVADOC_PRE_FENCE = "<pre>";
    private static final String JAVADOC_POST_FENCE = "</pre>";
    static final boolean[] VALID_SNIPPET_ID_CHARACTER;
    static final String[] JAVADOC_CODESNIPPET_REPLACEMENTS;

    public static void verifyCodesnippets(RootAndGlob codesnippetRootAndGlob, List<RootAndGlob> additionalCodesnippets, RootAndGlob sourcesRootAndGlob, boolean includeSources, RootAndGlob readmeRootAndGlob, List<RootAndGlob> additionalReadmes, boolean includeReadme, int maxLineLength, boolean failOnError, Log logger) throws IOException, MojoExecutionException {
        SnippetReplacer.runCodesnippets(codesnippetRootAndGlob, additionalCodesnippets, sourcesRootAndGlob, includeSources, readmeRootAndGlob, additionalReadmes, includeReadme, maxLineLength, failOnError, ExecutionMode.VERIFY, logger);
    }

    static List<CodesnippetError> verifyReadmeCodesnippets(Path file, Map<String, Codesnippet> snippetMap) throws IOException {
        return SnippetReplacer.verifySnippets(file, SnippetReplacer::getReadmeCall, snippetMap, "", "", "", null, 2048, true);
    }

    static List<CodesnippetError> verifySourceCodeSnippets(Path file, Map<String, Codesnippet> snippetMap, int maxLineLength) throws IOException {
        return SnippetReplacer.verifySnippets(file, SnippetReplacer::getSourceCall, snippetMap, JAVADOC_PRE_FENCE, JAVADOC_POST_FENCE, "* ", JAVADOC_CODESNIPPET_REPLACEMENTS, maxLineLength, false);
    }

    public static void updateCodesnippets(RootAndGlob codesnippetRootAndGlob, List<RootAndGlob> additionalCodesnippets, RootAndGlob sourcesRootAndGlob, boolean includeSources, RootAndGlob readmeRootAndGlob, List<RootAndGlob> additionalReadmes, boolean includeReadme, int maxLineLength, boolean failOnError, Log logger) throws IOException, MojoExecutionException {
        SnippetReplacer.runCodesnippets(codesnippetRootAndGlob, additionalCodesnippets, sourcesRootAndGlob, includeSources, readmeRootAndGlob, additionalReadmes, includeReadme, maxLineLength, failOnError, ExecutionMode.UPDATE, logger);
    }

    private static void runCodesnippets(RootAndGlob codesnippetRootAndGlob, List<RootAndGlob> additionalCodesnippets, RootAndGlob sourcesRootAndGlob, boolean includeSources, RootAndGlob readmeRootAndGlob, List<RootAndGlob> additionalReadmes, boolean includeReadme, int maxLineLength, boolean failOnError, ExecutionMode mode, Log logger) throws IOException, MojoExecutionException {
        if (!includeSources && !includeReadme) {
            logger.debug((CharSequence)"Neither sources or README were included. No codesnippet updating will be done.");
            return;
        }
        List<Object> sourceFiles = Collections.emptyList();
        if (includeSources && sourcesRootAndGlob.rootExists()) {
            sourceFiles = sourcesRootAndGlob.globFiles();
        }
        List<Object> readmeFiles = new ArrayList();
        if (includeReadme) {
            if (readmeRootAndGlob.rootExists()) {
                readmeFiles = readmeRootAndGlob.globFiles();
            }
            for (RootAndGlob rootAndGlob : additionalReadmes) {
                readmeFiles.addAll(rootAndGlob.globFiles());
            }
        }
        if (sourceFiles.isEmpty() && readmeFiles.isEmpty()) {
            logger.info((CharSequence)"No files to update.");
            return;
        }
        List<Path> codesnippetFiles = codesnippetRootAndGlob.globFiles();
        for (RootAndGlob additionalCodesnippet : additionalCodesnippets) {
            codesnippetFiles.addAll(additionalCodesnippet.globFiles());
        }
        Map<String, Codesnippet> map = SnippetReplacer.getAllSnippets(codesnippetFiles);
        ArrayList<CodesnippetError> errors = new ArrayList<CodesnippetError>();
        for (Path path : sourceFiles) {
            if (mode == ExecutionMode.UPDATE) {
                errors.addAll(SnippetReplacer.updateSourceCodeSnippets(path, map, maxLineLength));
                continue;
            }
            errors.addAll(SnippetReplacer.verifySourceCodeSnippets(path, map, maxLineLength));
        }
        for (Path path : readmeFiles) {
            if (mode == ExecutionMode.UPDATE) {
                errors.addAll(SnippetReplacer.updateReadmeCodesnippets(path, map));
                continue;
            }
            errors.addAll(SnippetReplacer.verifyReadmeCodesnippets(path, map));
        }
        if (!errors.isEmpty()) {
            String errorMessage = SnippetReplacer.createErrorMessage(mode == ExecutionMode.UPDATE ? "updating" : "verifying", maxLineLength, errors);
            logger.error((CharSequence)errorMessage);
            if (failOnError) {
                throw new MojoExecutionException(errorMessage);
            }
        }
    }

    static List<CodesnippetError> updateReadmeCodesnippets(Path file, Map<String, Codesnippet> snippetMap) throws IOException {
        return SnippetReplacer.updateSnippets(file, SnippetReplacer::getReadmeCall, snippetMap, "", "", "", null, 2048, true);
    }

    static List<CodesnippetError> updateSourceCodeSnippets(Path file, Map<String, Codesnippet> snippetMap, int maxLineLength) throws IOException {
        return SnippetReplacer.updateSnippets(file, SnippetReplacer::getSourceCall, snippetMap, JAVADOC_PRE_FENCE, JAVADOC_POST_FENCE, "* ", JAVADOC_CODESNIPPET_REPLACEMENTS, maxLineLength, false);
    }

    private static List<CodesnippetError> updateSnippets(Path file, BiFunction<String, Boolean, SnippetInfo> snippetTagMatcher, Map<String, Codesnippet> snippetMap, String preFence, String postFence, String additionalLinePrefix, String[] replacements, int maxLineLength, boolean prependSnippetTagIndentation) throws IOException {
        List<String> lines = Files.readAllLines(file, StandardCharsets.UTF_8);
        ArrayList<CodesnippetError> updateErrors = new ArrayList<CodesnippetError>();
        ArrayList<String> modifiedLines = new ArrayList<String>();
        boolean inSnippet = false;
        boolean needsAmend = false;
        String lineSep = System.lineSeparator();
        String currentSnippetId = "";
        int snippetTagIndentation = 0;
        for (String line : lines) {
            SnippetInfo begin = snippetTagMatcher.apply(line, true);
            if (begin != null) {
                modifiedLines.add(line);
                modifiedLines.add(lineSep);
                currentSnippetId = begin.snippetId;
                if (prependSnippetTagIndentation) {
                    snippetTagIndentation = begin.leadingWhitespace;
                }
                inSnippet = true;
                continue;
            }
            SnippetInfo end = snippetTagMatcher.apply(line, false);
            if (end != null) {
                if (inSnippet) {
                    if (!snippetMap.containsKey(currentSnippetId)) {
                        updateErrors.add(new CodesnippetMissingError(currentSnippetId, file));
                        needsAmend = true;
                        inSnippet = false;
                        modifiedLines.add(line);
                        modifiedLines.add(lineSep);
                        continue;
                    }
                    Codesnippet newSnippets = snippetMap.get(currentSnippetId);
                    ArrayList<String> modifiedSnippets = new ArrayList<String>();
                    String linePrefix = SnippetReplacer.prefixFunction(end, additionalLinePrefix);
                    int longestSnippetLine = 0;
                    byte[] whitespace = new byte[snippetTagIndentation];
                    Arrays.fill(whitespace, (byte)32);
                    String snippetIndentation = new String(whitespace);
                    for (String snippet : SnippetReplacer.respaceLines(newSnippets.getContent())) {
                        longestSnippetLine = Math.max(longestSnippetLine, snippet.length());
                        String modifiedSnippet = SnippetReplacer.applyReplacements(snippet, replacements);
                        modifiedSnippets.add(modifiedSnippet.isEmpty() ? SnippetReplacer.stripTrailingWhitespace(linePrefix) + lineSep : snippetIndentation + linePrefix + modifiedSnippet + lineSep);
                    }
                    if (longestSnippetLine > maxLineLength) {
                        updateErrors.add(new CodesnippetLengthError(currentSnippetId, file, longestSnippetLine));
                    }
                    if (preFence != null && !preFence.isEmpty()) {
                        modifiedLines.add(linePrefix);
                        modifiedLines.add(preFence);
                        modifiedLines.add(lineSep);
                    }
                    modifiedLines.addAll(modifiedSnippets);
                    if (postFence != null && !postFence.isEmpty()) {
                        modifiedLines.add(linePrefix);
                        modifiedLines.add(postFence);
                        modifiedLines.add(lineSep);
                    }
                    modifiedLines.add(line);
                    modifiedLines.add(lineSep);
                    needsAmend = true;
                    inSnippet = false;
                    continue;
                }
                modifiedLines.add(line);
                modifiedLines.add(lineSep);
                continue;
            }
            if (inSnippet) continue;
            modifiedLines.add(line);
            modifiedLines.add(lineSep);
        }
        if (needsAmend) {
            try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
                for (String line : modifiedLines) {
                    writer.write(line);
                }
            }
        }
        return updateErrors;
    }

    private static List<CodesnippetError> verifySnippets(Path file, BiFunction<String, Boolean, SnippetInfo> snippetTagMatcher, Map<String, Codesnippet> snippetMap, String preFence, String postFence, String additionalLinePrefix, String[] replacements, int maxLineLength, boolean prependSnippetTagIndentation) throws IOException {
        List<String> lines = Files.readAllLines(file, StandardCharsets.UTF_8);
        boolean inSnippet = false;
        String lineSep = System.lineSeparator();
        ArrayList<String> currentSnippetSet = null;
        ArrayList<CodesnippetError> verificationErrors = new ArrayList<CodesnippetError>();
        String currentSnippetId = "";
        int snippetTagIndentation = 0;
        for (String line : lines) {
            SnippetInfo begin = snippetTagMatcher.apply(line, true);
            if (begin != null) {
                currentSnippetId = begin.snippetId;
                inSnippet = true;
                if (prependSnippetTagIndentation) {
                    snippetTagIndentation = begin.leadingWhitespace;
                }
                currentSnippetSet = new ArrayList<String>();
                continue;
            }
            SnippetInfo end = snippetTagMatcher.apply(line, false);
            if (end != null) {
                if (!inSnippet) continue;
                if (!snippetMap.containsKey(currentSnippetId)) {
                    verificationErrors.add(new CodesnippetMissingError(currentSnippetId, file));
                    inSnippet = false;
                    currentSnippetSet = null;
                    continue;
                }
                Codesnippet newSnippets = snippetMap.get(currentSnippetId);
                ArrayList<String> modifiedSnippets = new ArrayList<String>();
                String linePrefix = SnippetReplacer.prefixFunction(end, additionalLinePrefix);
                int longestSnippetLine = 0;
                byte[] whitespace = new byte[snippetTagIndentation];
                Arrays.fill(whitespace, (byte)32);
                String snippetIndentation = new String(whitespace);
                for (String snippet : SnippetReplacer.respaceLines(newSnippets.getContent())) {
                    longestSnippetLine = Math.max(longestSnippetLine, snippet.length());
                    String modifiedSnippet = SnippetReplacer.applyReplacements(snippet, replacements);
                    modifiedSnippets.add(modifiedSnippet.isEmpty() ? SnippetReplacer.stripTrailingWhitespace(linePrefix) + lineSep : snippetIndentation + linePrefix + modifiedSnippet + lineSep);
                }
                if (longestSnippetLine > maxLineLength) {
                    verificationErrors.add(new CodesnippetLengthError(currentSnippetId, file, longestSnippetLine));
                }
                if (!modifiedSnippets.equals(currentSnippetSet)) {
                    verificationErrors.add(new CodesnippetMismatchError(currentSnippetId, file));
                }
                inSnippet = false;
                currentSnippetSet = null;
                continue;
            }
            if (!inSnippet) continue;
            if (!preFence.isEmpty() && !postFence.isEmpty()) {
                if (line.contains(preFence) || line.contains(postFence)) continue;
                currentSnippetSet.add(line + lineSep);
                continue;
            }
            currentSnippetSet.add(line + lineSep);
        }
        return verificationErrors;
    }

    static Map<String, Codesnippet> getAllSnippets(List<Path> snippetSources) throws IOException, MojoExecutionException {
        HashMap<String, List<Codesnippet>> codesnippets = new HashMap<String, List<Codesnippet>>();
        HashMap<String, List<String>> missingBeginTag = new HashMap<String, List<String>>();
        HashMap<String, List<String>> missingEndTag = new HashMap<String, List<String>>();
        for (Path samplePath : snippetSources) {
            List<String> fileContent = Files.readAllLines(samplePath, StandardCharsets.UTF_8);
            SnippetDictionary snippetReader = new SnippetDictionary();
            for (String line : fileContent) {
                SnippetInfo begin = SnippetReplacer.getSnippetDefinition(line, true);
                if (begin != null) {
                    String id_beginning = begin.snippetId;
                    snippetReader.beginSnippet(id_beginning);
                    continue;
                }
                SnippetInfo end = SnippetReplacer.getSnippetDefinition(line, false);
                if (end != null) {
                    String id_ending = end.snippetId;
                    List<String> snippetContent = snippetReader.finalizeSnippet(id_ending);
                    codesnippets.compute(id_ending, (key, value) -> {
                        if (value == null) {
                            value = new ArrayList<Codesnippet>();
                        }
                        value.add(new Codesnippet((String)key, samplePath, snippetContent));
                        return value;
                    });
                    continue;
                }
                if (!snippetReader.isActive()) continue;
                snippetReader.processLine(line);
            }
            if (!snippetReader.getMissingEndTags().isEmpty()) {
                missingEndTag.put(samplePath.toString(), snippetReader.getMissingEndTags());
            }
            if (snippetReader.getMissingBeginTags().isEmpty()) continue;
            missingBeginTag.put(samplePath.toString(), snippetReader.getMissingBeginTags());
        }
        String potentialErrorMessage = SnippetReplacer.createInvalidSnippetsErrorMessage(codesnippets, missingEndTag, missingBeginTag);
        if (!potentialErrorMessage.isEmpty()) {
            throw new MojoExecutionException(potentialErrorMessage);
        }
        return codesnippets.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (Codesnippet)((List)entry.getValue()).get(0)));
    }

    private static String createInvalidSnippetsErrorMessage(Map<String, List<Codesnippet>> codesnippets, Map<String, List<String>> missingEndTags, Map<String, List<String>> missingBeginTags) {
        StringBuilder errorMessage = new StringBuilder();
        for (Map.Entry<String, List<Codesnippet>> entry : codesnippets.entrySet()) {
            if (entry.getValue().size() == 1) continue;
            if (errorMessage.length() == 0) {
                errorMessage.append("Multiple codesnippets used the same identifier:").append(System.lineSeparator()).append(System.lineSeparator());
            }
            errorMessage.append("Codesnippet ID '").append(entry.getKey()).append("' was used multiple times. Found in files:").append(System.lineSeparator());
            for (Codesnippet codesnippet : entry.getValue()) {
                errorMessage.append("--> ").append(codesnippet.getDefinitionLocation()).append(System.lineSeparator());
            }
            errorMessage.append(System.lineSeparator());
        }
        for (Map.Entry<String, List<Object>> entry : missingEndTags.entrySet()) {
            errorMessage.append("The following codesnippet aliases in file' ").append(entry.getKey()).append("' didn't have a matching END alias:").append(System.lineSeparator());
            for (String string : entry.getValue()) {
                errorMessage.append(" - ").append(string).append(System.lineSeparator());
            }
            errorMessage.append(System.lineSeparator());
        }
        for (Map.Entry<String, List<Object>> entry : missingBeginTags.entrySet()) {
            errorMessage.append("The following codesnippet aliases in file '").append(entry.getKey()).append("' didn't have a matching BEGIN alias:").append(System.lineSeparator());
            for (String string : entry.getValue()) {
                errorMessage.append(" - ").append(string).append(System.lineSeparator());
            }
            errorMessage.append(System.lineSeparator());
        }
        return errorMessage.toString();
    }

    private static List<String> respaceLines(List<String> snippetText) {
        String snippetLine2;
        int leadingWhitespace;
        int minWhitespace = Integer.MAX_VALUE;
        ArrayList<String> modifiedStrings = new ArrayList<String>();
        Iterator<String> iterator = snippetText.iterator();
        while (iterator.hasNext() && ((leadingWhitespace = SnippetReplacer.nextNonWhitespace(snippetLine2 = iterator.next(), 0)) == -1 || (minWhitespace = Math.min(minWhitespace, leadingWhitespace)) != 0)) {
        }
        if (minWhitespace > 0) {
            for (String snippetLine2 : snippetText) {
                if (snippetLine2.length() >= minWhitespace) {
                    modifiedStrings.add(snippetLine2.substring(minWhitespace));
                    continue;
                }
                modifiedStrings.add(snippetLine2);
            }
        } else {
            return snippetText;
        }
        return modifiedStrings;
    }

    private static String prefixFunction(SnippetInfo snippetInfo, String additionalPrefix) {
        if (snippetInfo == null || !snippetInfo.additionalPrefix) {
            return "";
        }
        return snippetInfo.additionalPrefixString + additionalPrefix;
    }

    static String applyReplacements(String snippet, String[] replacements) {
        if (replacements == null || replacements.length == 0) {
            return snippet;
        }
        int snippetLength = snippet.length();
        StringBuilder replacer = null;
        int prevStart = 0;
        for (int i = 0; i < snippetLength; ++i) {
            String replacement;
            char c = snippet.charAt(i);
            if (c >= '\u0080' || (replacement = replacements[c]) == null) continue;
            if (replacer == null) {
                replacer = new StringBuilder(snippet.length() + 500);
            }
            if (prevStart != i) {
                replacer.append(snippet, prevStart, i);
            }
            replacer.append(replacement);
            prevStart = i + 1;
        }
        if (replacer == null) {
            return snippet;
        }
        replacer.append(snippet, prevStart, snippet.length());
        return replacer.toString();
    }

    private static String createErrorMessage(String operationKind, int allowedLength, List<CodesnippetError> errors) {
        List lengthErrorMessages;
        List missingErrorMessages;
        StringBuilder errorMessageBuilder = new StringBuilder("codesnippet-maven-plugin has encountered errors while ").append(operationKind).append(" codesnippets.").append(System.lineSeparator()).append(System.lineSeparator());
        List mismatchErrorMessages = errors.stream().filter(error -> error instanceof CodesnippetMismatchError).map(CodesnippetError::getErrorMessage).collect(Collectors.toList());
        if (!mismatchErrorMessages.isEmpty()) {
            errorMessageBuilder.append("The following codesnippets need updates:").append(System.lineSeparator());
            for (Object errorMessage : mismatchErrorMessages) {
                errorMessageBuilder.append((String)errorMessage).append(System.lineSeparator());
            }
        }
        if (!(missingErrorMessages = errors.stream().filter(error -> error instanceof CodesnippetMissingError).map(CodesnippetError::getErrorMessage).collect(Collectors.toList())).isEmpty()) {
            errorMessageBuilder.append(System.lineSeparator()).append("The following codesnippets were missing:").append(System.lineSeparator());
            for (String errorMessage : missingErrorMessages) {
                errorMessageBuilder.append(errorMessage).append(System.lineSeparator());
            }
        }
        if (!(lengthErrorMessages = errors.stream().filter(error -> error instanceof CodesnippetLengthError).map(CodesnippetError::getErrorMessage).collect(Collectors.toList())).isEmpty()) {
            errorMessageBuilder.append(System.lineSeparator()).append("The following codesnippets exceeded the allowed length(").append(allowedLength).append("):").append(System.lineSeparator());
            for (String errorMessage : lengthErrorMessages) {
                errorMessageBuilder.append(errorMessage).append(System.lineSeparator());
            }
        }
        return errorMessageBuilder.toString();
    }

    private static int leadingWhitespaceCount(String str) {
        int count = SnippetReplacer.nextNonWhitespace(str, 0);
        return count == -1 ? 0 : count;
    }

    private static int nextNonWhitespace(String str, int offset) {
        if (str == null || str.isEmpty() || str.length() - 1 == offset) {
            return -1;
        }
        int length = str.length();
        while (offset < length) {
            if (!Character.isWhitespace(str.charAt(offset))) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    private static String stripTrailingWhitespace(String str) {
        int end;
        if (str == null || str.isEmpty()) {
            return str;
        }
        for (end = str.length() - 1; end > 0 && Character.isWhitespace(str.charAt(end)); --end) {
        }
        return str.substring(0, end + 1);
    }

    private static String getSnippetId(String str, int offset) {
        if (str == null || str.isEmpty() || str.length() - 1 == offset) {
            return null;
        }
        int strLength = str.length();
        int start = SnippetReplacer.nextNonWhitespace(str, offset);
        if (start == -1) {
            return null;
        }
        for (int end = start; end < strLength; ++end) {
            char c = str.charAt(end);
            if (c < '\u0080' && VALID_SNIPPET_ID_CHARACTER[c]) continue;
            if (!Character.isWhitespace(c)) {
                return null;
            }
            return str.substring(start, end);
        }
        return str.substring(start);
    }

    private static SnippetInfo getSnippetDefinition(String str, boolean beginDefinition) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        int leadingWhitespace = SnippetReplacer.leadingWhitespaceCount(str);
        int offset = leadingWhitespace;
        if (!str.regionMatches(offset, "//", 0, 2)) {
            return null;
        }
        if ((offset = SnippetReplacer.nextNonWhitespace(str, offset + 2)) == -1) {
            return null;
        }
        if (beginDefinition ? !str.regionMatches(offset, "BEGIN:", 0, 6) : !str.regionMatches(offset, "END:", 0, 4)) {
            return null;
        }
        String snippetId = SnippetReplacer.getSnippetId(str, beginDefinition ? offset + 6 : offset + 4);
        return snippetId == null ? null : new SnippetInfo(leadingWhitespace, snippetId, false);
    }

    private static SnippetInfo getSourceCall(String str, boolean beginSourceCall) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        int leadingWhitespace = SnippetReplacer.leadingWhitespaceCount(str);
        int offset = leadingWhitespace;
        if (str.charAt(offset) != '*') {
            return null;
        }
        if ((offset = SnippetReplacer.nextNonWhitespace(str, offset + 1)) == -1) {
            return null;
        }
        if (!str.regionMatches(offset, "<!--", 0, 4)) {
            return null;
        }
        if ((offset = SnippetReplacer.nextNonWhitespace(str, offset + 4)) == -1) {
            return null;
        }
        if (beginSourceCall ? !str.regionMatches(offset, "src_embed", 0, 9) : !str.regionMatches(offset, "end", 0, 3)) {
            return null;
        }
        offset = beginSourceCall ? offset + 9 : offset + 3;
        String snippetId = SnippetReplacer.getSnippetId(str, offset);
        if (snippetId == null) {
            return null;
        }
        return !str.regionMatches(offset = SnippetReplacer.nextNonWhitespace(str, offset + snippetId.length() + 1), "-->", 0, 3) ? null : new SnippetInfo(leadingWhitespace, snippetId, true);
    }

    private static SnippetInfo getReadmeCall(String str, boolean beginReadmeCall) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        int leadingWhitespace = SnippetReplacer.leadingWhitespaceCount(str);
        int offset = leadingWhitespace;
        if (!str.regionMatches(offset, "```", 0, 3)) {
            return null;
        }
        if (!beginReadmeCall) {
            return new SnippetInfo(leadingWhitespace, null, false);
        }
        if ((offset = SnippetReplacer.nextNonWhitespace(str, offset + 3)) == -1) {
            return null;
        }
        if (!str.regionMatches(offset, "java", 0, 4)) {
            return null;
        }
        String snippetId = SnippetReplacer.getSnippetId(str, offset + 4);
        return snippetId == null ? null : new SnippetInfo(leadingWhitespace, snippetId, false);
    }

    private SnippetReplacer() {
    }

    static {
        JAVADOC_CODESNIPPET_REPLACEMENTS = new String[128];
        SnippetReplacer.JAVADOC_CODESNIPPET_REPLACEMENTS[38] = "&amp;";
        SnippetReplacer.JAVADOC_CODESNIPPET_REPLACEMENTS[34] = "&quot;";
        SnippetReplacer.JAVADOC_CODESNIPPET_REPLACEMENTS[62] = "&gt;";
        SnippetReplacer.JAVADOC_CODESNIPPET_REPLACEMENTS[60] = "&lt;";
        SnippetReplacer.JAVADOC_CODESNIPPET_REPLACEMENTS[64] = "&#64;";
        SnippetReplacer.JAVADOC_CODESNIPPET_REPLACEMENTS[123] = "&#123;";
        SnippetReplacer.JAVADOC_CODESNIPPET_REPLACEMENTS[125] = "&#125;";
        SnippetReplacer.JAVADOC_CODESNIPPET_REPLACEMENTS[40] = "&#40;";
        SnippetReplacer.JAVADOC_CODESNIPPET_REPLACEMENTS[41] = "&#41;";
        SnippetReplacer.JAVADOC_CODESNIPPET_REPLACEMENTS[47] = "&#47;";
        SnippetReplacer.JAVADOC_CODESNIPPET_REPLACEMENTS[92] = "&#92;";
        VALID_SNIPPET_ID_CHARACTER = new boolean[128];
        Arrays.fill(VALID_SNIPPET_ID_CHARACTER, 97, 123, true);
        Arrays.fill(VALID_SNIPPET_ID_CHARACTER, 65, 91, true);
        Arrays.fill(VALID_SNIPPET_ID_CHARACTER, 48, 58, true);
        SnippetReplacer.VALID_SNIPPET_ID_CHARACTER[46] = true;
        SnippetReplacer.VALID_SNIPPET_ID_CHARACTER[35] = true;
        SnippetReplacer.VALID_SNIPPET_ID_CHARACTER[92] = true;
        SnippetReplacer.VALID_SNIPPET_ID_CHARACTER[45] = true;
        SnippetReplacer.VALID_SNIPPET_ID_CHARACTER[95] = true;
    }

    private static final class SnippetInfo {
        private final int leadingWhitespace;
        private final String snippetId;
        private final boolean additionalPrefix;
        private final String additionalPrefixString;

        SnippetInfo(int leadingWhitespace, String snippetId, boolean additionalPrefix) {
            this.leadingWhitespace = leadingWhitespace;
            this.snippetId = snippetId;
            this.additionalPrefix = additionalPrefix;
            if (additionalPrefix) {
                StringBuilder prefixBuilder = new StringBuilder(leadingWhitespace);
                for (int i = 0; i < leadingWhitespace; ++i) {
                    prefixBuilder.append(" ");
                }
                this.additionalPrefixString = prefixBuilder.toString();
            } else {
                this.additionalPrefixString = null;
            }
        }
    }
}

