/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.commo;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;

public class CommoProcess
implements Runnable {
    private boolean isErr;
    private String subname = "";
    private InputStream isem;
    private String proName;
    private String log = null;
    private boolean doDrain;
    private static HashMap processes = new HashMap();

    CommoProcess(boolean bl, InputStream inputStream, String string, boolean bl2) {
        this.isErr = bl;
        this.subname = this.isErr ? string + " - STDERROR" : string + " - STDOut";
        this.isem = inputStream;
        this.proName = string;
        this.doDrain = bl2;
    }

    CommoProcess(boolean bl, InputStream inputStream, String string, boolean bl2, String string2) {
        this.isErr = bl;
        this.subname = this.isErr ? string + " - STDERROR" : string + " - STDOut";
        this.isem = inputStream;
        this.proName = string;
        this.doDrain = bl2;
        this.log = string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            PrintStream printStream;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.isem));
            FileOutputStream fileOutputStream = null;
            BufferedOutputStream bufferedOutputStream = null;
            String string = "";
            if (this.log != null) {
                fileOutputStream = new FileOutputStream(new File(this.log));
                bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                printStream = new PrintStream(bufferedOutputStream, true);
            } else {
                printStream = System.out;
                string = this.proName + ": ";
            }
            try {
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (!this.doDrain) continue;
                    printStream.println(string + string2);
                }
            }
            catch (IOException iOException) {
                if (this.doDrain) {
                    printStream.println(string + "IOException when running CommoProcess");
                    iOException.printStackTrace();
                }
            }
            finally {
                if (this.doDrain) {
                    printStream.println(string + "Stopped draining " + this.proName);
                }
                if (this.log != null) {
                    printStream.flush();
                    printStream.close();
                    try {
                        bufferedOutputStream.flush();
                    }
                    catch (IOException iOException) {}
                    try {
                        bufferedOutputStream.close();
                    }
                    catch (IOException iOException) {}
                    try {
                        fileOutputStream.flush();
                    }
                    catch (IOException iOException) {}
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Error running the Commo process " + exception);
        }
    }

    static void destroyProcesses(String string) {
        if (string == null) {
            for (Process process : processes.keySet()) {
                process.destroy();
            }
        } else {
            Iterator iterator = processes.keySet().iterator();
            Process process = null;
            while (iterator.hasNext()) {
                process = (Process)iterator.next();
                String string2 = (String)processes.get(process);
                if (!string2.equals(string)) continue;
                System.out.println("Killing process " + string2);
                process.destroy();
                break;
            }
            if (process != null) {
                processes.remove(process);
            }
        }
    }

    static Process getProcess(String string) {
        try {
            Iterator iterator = processes.keySet().iterator();
            Process process = null;
            while (iterator.hasNext()) {
                process = (Process)iterator.next();
                String string2 = (String)processes.get(process);
                if (!string2.equals(string)) continue;
                return process;
            }
        }
        catch (Exception exception) {
            System.out.println("Error getting the process " + exception);
        }
        return null;
    }

    public static void startIOThreads(Process process, String string, boolean bl, String string2) {
        Thread thread = new Thread(new CommoProcess(false, process.getInputStream(), string, bl, string2));
        thread.setDaemon(true);
        thread.start();
        Thread thread2 = new Thread(new CommoProcess(true, process.getErrorStream(), string, bl, string2));
        thread2.setDaemon(true);
        thread2.start();
        processes.put(process, string);
    }

    public static void startIOThreads(Process process, String string, boolean bl) {
        Thread thread = new Thread(new CommoProcess(false, process.getInputStream(), string, bl));
        thread.setDaemon(true);
        thread.start();
        Thread thread2 = new Thread(new CommoProcess(true, process.getErrorStream(), string, bl));
        thread2.setDaemon(true);
        thread2.start();
        processes.put(process, string);
    }
}

