/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

import java.io.UnsupportedEncodingException;

public final class Hex {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final int COLS_PER_ROW = 8;
    private static final int BYTES_PER_ROW = 16;

    private Hex() {
    }

    public static String asHex(byte[] byArray, int n) {
        return Hex.asHex(byArray, n, true);
    }

    public static String asUnicode(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            string2 = string2 + "\\u" + Hex.asHex(string.charAt(i) >> 8) + Hex.asHex(string.charAt(i));
        }
        return string2;
    }

    public static String asUnicode(char c) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\\u");
        stringBuffer.append(Hex.asHex(c >> 8) + Hex.asHex(c));
        return stringBuffer.toString();
    }

    public static String asHex(String string, String string2) throws UnsupportedEncodingException {
        byte[] byArray = string.getBytes(string2);
        return Hex.asHex(byArray);
    }

    public static byte[] asHexBytes(byte[] byArray, int n, boolean bl) {
        byte[] byArray2;
        int n2 = Math.min(n, byArray.length);
        int n3 = 0;
        if (bl) {
            byArray2 = new byte[n2 * 2 + 2];
            byArray2[0] = 48;
            byArray2[1] = 120;
            n3 += 2;
        } else {
            byArray2 = new byte[n2 * 2];
        }
        for (int i = 0; i < n2; ++i) {
            byArray2[n3++] = (byte)HEX_CHARS[(byArray[i] & 0xF0) >> 4];
            byArray2[n3++] = (byte)HEX_CHARS[(byArray[i] & 0xF) >> 0];
        }
        return byArray2;
    }

    public static String asHex(byte[] byArray, int n, boolean bl) {
        return new String(Hex.asHexBytes(byArray, n, bl), 0);
    }

    public static byte[] fromHexString(byte[] byArray, int n) {
        int n2 = 0;
        if (byArray[0] == 48 && (byArray[1] == 120 || byArray[1] == 88)) {
            n2 += 2;
            n -= 2;
        }
        int n3 = n / 2;
        byte[] byArray2 = new byte[n3];
        for (int i = 0; i < n3; ++i) {
            byArray2[i] = (byte)(Hex.hexValueOf(byArray[n2++]) << 4 | Hex.hexValueOf(byArray[n2++]));
        }
        return byArray2;
    }

    public static byte[] fromHexString(String string) {
        byte[] byArray;
        try {
            byArray = string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = new byte[string.length()];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = (byte)string.charAt(i);
            }
        }
        return Hex.fromHexString(byArray, byArray.length);
    }

    public static String asHex(int n) {
        char[] cArray = new char[]{HEX_CHARS[(n & 0xF0) >> 4], HEX_CHARS[(n & 0xF) >> 0]};
        return new String(cArray);
    }

    public static String asHex(byte[] byArray) {
        return Hex.asHex(byArray, byArray.length);
    }

    public static int hexValueOf(int n) {
        if (n >= 48 && n <= 57) {
            return n - 48;
        }
        if (n >= 97 && n <= 102) {
            return n - 97 + 10;
        }
        if (n >= 65 && n <= 70) {
            return n - 65 + 10;
        }
        return 0;
    }

    public static String dump(byte[] byArray) {
        if (byArray == null) {
            return "" + byArray;
        }
        return Hex.dump(byArray, 0, byArray.length);
    }

    public static String dump(byte[] byArray, int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        int n3 = Math.min(byArray.length, n + n2);
        int n4 = n & 0xFFFFFFF0;
        int n5 = n3 + 15 & 0xFFFFFFF0;
        StringBuffer stringBuffer = new StringBuffer();
        int n6 = n4;
        for (int i = n4; i < n5; ++i) {
            if (i % 16 == 0) {
                Hex.lineLabel(stringBuffer, i);
                n6 = i;
            }
            if (i < n || i >= n3) {
                stringBuffer.append("  ");
            } else {
                stringBuffer.append(Hex.asHex(byArray[i]));
            }
            if (i % 2 == 1) {
                stringBuffer.append(' ');
            }
            if (i % 16 != 15) continue;
            stringBuffer.append("  ");
            for (int j = n6; j < n6 + 16; ++j) {
                if (j < n || j >= n3) {
                    stringBuffer.append(' ');
                    continue;
                }
                stringBuffer.append(Hex.toPrint(byArray[j]));
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public static final boolean isHexChar(int n) {
        switch (n) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                return true;
            }
        }
        return false;
    }

    private static char toPrint(byte by) {
        byte by2 = by;
        if (by2 < 32 || by2 > 126) {
            return '.';
        }
        return (char)by2;
    }

    private static void lineLabel(StringBuffer stringBuffer, int n) {
        StringBuffer stringBuffer2;
        String string = new Integer(n).toString();
        if (string.length() <= 5) {
            stringBuffer2 = new StringBuffer("    ");
            stringBuffer2.insert(5 - string.length(), string);
            stringBuffer2.setLength(5);
        } else {
            stringBuffer2 = new StringBuffer(string);
        }
        stringBuffer.append(stringBuffer2);
        stringBuffer.append(": ");
    }
}

