/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import weblogic.utils.collections.EmbeddedListElement;
import weblogic.utils.collections.EmbeddedListIterator;

public final class EmbeddedList
extends AbstractList {
    protected int size;
    protected EmbeddedListElement first;
    protected EmbeddedListElement last;

    public boolean add(Object object) {
        EmbeddedListElement embeddedListElement = (EmbeddedListElement)object;
        if (embeddedListElement.getList() != null) {
            throw new IllegalArgumentException();
        }
        embeddedListElement.setNext(null);
        if (this.first == null) {
            this.first = embeddedListElement;
        } else {
            this.last.setNext(embeddedListElement);
        }
        embeddedListElement.setPrev(this.last);
        this.last = embeddedListElement;
        embeddedListElement.setList(this);
        ++this.size;
        return true;
    }

    public void moveToEnd(EmbeddedList embeddedList) {
        if (embeddedList == this) {
            throw new IllegalArgumentException();
        }
        if (embeddedList.isEmpty()) {
            return;
        }
        if (this.first == null) {
            this.first = embeddedList.first;
        } else {
            this.last.setNext(embeddedList.first);
            embeddedList.first.setPrev(this.last);
        }
        this.last = embeddedList.last;
        this.size += embeddedList.size;
        for (EmbeddedListElement embeddedListElement = embeddedList.first; embeddedListElement != null; embeddedListElement = embeddedListElement.getNext()) {
            embeddedListElement.setList(this);
        }
        embeddedList.last = null;
        embeddedList.first = null;
        embeddedList.size = 0;
    }

    public void clear() {
        while (this.first != null) {
            this.remove(this.first);
        }
    }

    public boolean contains(Object object) {
        return ((EmbeddedListElement)object).getList() == this;
    }

    public Object get(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        EmbeddedListElement embeddedListElement = this.first;
        for (int i = 1; i < n; ++i) {
            embeddedListElement = embeddedListElement.getNext();
        }
        return embeddedListElement;
    }

    public Object first() {
        return this.first;
    }

    public Object last() {
        return this.last;
    }

    public boolean remove(Object object) {
        EmbeddedListElement embeddedListElement = (EmbeddedListElement)object;
        if (!this.contains(embeddedListElement)) {
            return false;
        }
        if (embeddedListElement.getNext() != null) {
            embeddedListElement.getNext().setPrev(embeddedListElement.getPrev());
        } else {
            this.last = embeddedListElement.getPrev();
        }
        if (embeddedListElement.getPrev() == null) {
            this.first = embeddedListElement.getNext();
        } else {
            embeddedListElement.getPrev().setNext(embeddedListElement.getNext());
        }
        embeddedListElement.setList(null);
        embeddedListElement.setPrev(null);
        embeddedListElement.setNext(null);
        --this.size;
        return true;
    }

    public EmbeddedList split(EmbeddedListElement embeddedListElement, boolean bl) {
        if (!this.contains(embeddedListElement)) {
            throw new NoSuchElementException();
        }
        EmbeddedList embeddedList = new EmbeddedList();
        if (bl) {
            if (embeddedListElement == this.last) {
                return embeddedList;
            }
            embeddedList.first = embeddedListElement.getNext();
            embeddedList.last = this.last;
            this.last = embeddedListElement;
            embeddedList.first.setPrev(null);
            this.last.setNext(null);
        } else {
            embeddedList.first = embeddedListElement;
            embeddedList.last = this.last;
            if (embeddedListElement == this.first) {
                this.last = null;
                this.first = null;
            } else {
                this.last = embeddedListElement.getPrev();
                this.last.setNext(null);
                embeddedListElement.setPrev(null);
            }
        }
        embeddedListElement = embeddedList.first;
        while (embeddedListElement != null) {
            embeddedListElement.setList(embeddedList);
            embeddedListElement = embeddedListElement.getNext();
            ++embeddedList.size;
            --this.size;
        }
        return embeddedList;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public ListIterator iterator(EmbeddedListElement embeddedListElement) {
        return new Itr(embeddedListElement);
    }

    public Iterator iterator() {
        return new Itr(this.first);
    }

    public ListIterator listIterator() {
        return new Itr(this.first);
    }

    public EmbeddedListIterator embeddedListIterator() {
        return new Itr(this.first);
    }

    public Object[] toArray(Object[] objectArray) {
        Object[] objectArray2 = objectArray != null && objectArray.length >= this.size ? objectArray : new Object[this.size];
        int n = 0;
        EmbeddedListElement embeddedListElement = this.first;
        while (embeddedListElement != null) {
            objectArray2[n] = embeddedListElement;
            embeddedListElement = embeddedListElement.getNext();
            ++n;
        }
        return objectArray2;
    }

    public Object[] toArray() {
        return this.toArray((Object[])null);
    }

    private final class Itr
    implements EmbeddedListIterator {
        private EmbeddedListElement cursor;
        private EmbeddedListElement element;

        Itr(EmbeddedListElement embeddedListElement) {
            this.reset(embeddedListElement);
        }

        public void reset(EmbeddedListElement embeddedListElement) {
            if (embeddedListElement != null && !EmbeddedList.this.contains(embeddedListElement)) {
                throw new IllegalArgumentException("List does not contain the specified element");
            }
            this.cursor = embeddedListElement;
            this.element = null;
        }

        public boolean hasNext() {
            return this.cursor != null;
        }

        public boolean hasPrevious() {
            if (this.cursor == null) {
                return EmbeddedList.this.last != null;
            }
            return this.cursor.getPrev() != null;
        }

        public Object next() {
            if (this.cursor == null) {
                throw new NoSuchElementException();
            }
            this.element = this.cursor;
            this.cursor = this.cursor.getNext();
            return this.element;
        }

        public Object previous() {
            if (this.cursor != null) {
                EmbeddedListElement embeddedListElement = this.cursor.getPrev();
                if (embeddedListElement != null) {
                    this.element = embeddedListElement;
                    this.cursor = embeddedListElement;
                    return embeddedListElement;
                }
                throw new NoSuchElementException();
            }
            if (EmbeddedList.this.last != null) {
                this.element = EmbeddedList.this.last;
                this.cursor = EmbeddedList.this.last;
                return this.element;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.element == null) {
                throw new IllegalStateException();
            }
            if (this.element == this.cursor) {
                this.cursor = this.cursor.getNext();
            }
            EmbeddedList.this.remove(this.element);
            this.element = null;
        }

        public void set(Object object) {
            if (this.element == null) {
                throw new IllegalStateException();
            }
            EmbeddedListElement embeddedListElement = (EmbeddedListElement)object;
            this.remove();
            this.add(embeddedListElement);
            if (this.cursor == this.element) {
                this.cursor = embeddedListElement;
            }
            this.element = embeddedListElement;
        }

        public void add(Object object) {
            EmbeddedListElement embeddedListElement = (EmbeddedListElement)object;
            if (embeddedListElement.getList() != null) {
                throw new IllegalArgumentException();
            }
            if (this.cursor != null) {
                embeddedListElement.setNext(this.cursor);
                embeddedListElement.setPrev(this.cursor.getPrev());
                this.cursor.setPrev(embeddedListElement);
            } else {
                embeddedListElement.setNext(null);
                embeddedListElement.setPrev(EmbeddedList.this.last);
                EmbeddedList.this.last = embeddedListElement;
            }
            if (embeddedListElement.getPrev() == null) {
                EmbeddedList.this.first = embeddedListElement;
            } else {
                embeddedListElement.getPrev().setNext(embeddedListElement);
            }
            this.element = null;
            embeddedListElement.setList(EmbeddedList.this);
            ++EmbeddedList.this.size;
        }

        public int nextIndex() {
            if (this.cursor == null) {
                return EmbeddedList.this.size;
            }
            int n = 0;
            for (EmbeddedListElement embeddedListElement = this.cursor.getPrev(); embeddedListElement != null; embeddedListElement = embeddedListElement.getPrev()) {
                ++n;
            }
            return n;
        }

        public int previousIndex() {
            if (this.cursor == null) {
                return EmbeddedList.this.size - 1;
            }
            EmbeddedListElement embeddedListElement = this.cursor.getPrev();
            int n = -1;
            while (embeddedListElement != null) {
                embeddedListElement = embeddedListElement.getPrev();
                ++n;
            }
            return n;
        }
    }
}

