/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class NumericKeyHashMap {
    private transient Entry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private transient Collection values;

    protected Entry createEntry(long l, Object object, Entry entry) {
        return new Entry(l, object, entry);
    }

    public NumericKeyHashMap(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = f;
        this.table = new Entry[n];
        this.threshold = (int)((float)n * f);
    }

    public NumericKeyHashMap(int n) {
        this(n, 0.75f);
    }

    public NumericKeyHashMap() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean containsValue(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        while (n-- > 0) {
            Entry entry = entryArray[n];
            while (entry != null) {
                if (entry.value.equals(object)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public boolean containsKey(long l) {
        Entry[] entryArray = this.table;
        int n = (int)((l & Integer.MAX_VALUE) % (long)entryArray.length);
        Entry entry = entryArray[n];
        while (entry != null) {
            if (entry.key == l) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public Object get(long l) {
        Entry[] entryArray = this.table;
        int n = (int)((l & Integer.MAX_VALUE) % (long)entryArray.length);
        Entry entry = entryArray[n];
        while (entry != null) {
            if (entry.key == l) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    protected void rehash() {
        int n = this.table.length;
        Entry[] entryArray = this.table;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = (int)((entry2.key & Integer.MAX_VALUE) % (long)n2);
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    public Object put(long l, Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Entry[] entryArray = this.table;
        int n = (int)((l & Integer.MAX_VALUE) % (long)entryArray.length);
        Entry entry = entryArray[n];
        while (entry != null) {
            if (entry.key == l) {
                Object object2 = entry.value;
                entry.value = object;
                return object2;
            }
            entry = entry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(l, object);
        }
        entryArray[n] = this.createEntry(l, object, entryArray[n]);
        ++this.count;
        return null;
    }

    public Object remove(long l) {
        Entry[] entryArray = this.table;
        int n = (int)((l & Integer.MAX_VALUE) % (long)entryArray.length);
        Entry entry = entryArray[n];
        Entry entry2 = null;
        while (entry != null) {
            if (entry.key == l) {
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n] = entry.next;
                }
                --this.count;
                return entry.value;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return null;
    }

    public void clear() {
        Object[] objectArray = this.table;
        Arrays.fill(objectArray, null);
        this.count = 0;
    }

    public Collection values() {
        Collection collection = this.values;
        return collection != null ? collection : (this.values = new Values());
    }

    private class Values
    extends AbstractCollection {
        private Values() {
        }

        public int size() {
            return NumericKeyHashMap.this.size();
        }

        public Iterator iterator() {
            return new Iterator(){
                int pos;
                Entry current;
                Entry next;

                public boolean hasNext() {
                    return this.setNext() != null;
                }

                public Object next() {
                    Entry entry = this.setNext();
                    this.next = null;
                    return entry.value;
                }

                private Entry setNext() {
                    if (this.next != null) {
                        return this.next;
                    }
                    while (this.current == null && this.pos < NumericKeyHashMap.this.table.length) {
                        this.current = NumericKeyHashMap.this.table[this.pos++];
                    }
                    this.next = this.current;
                    if (this.current != null) {
                        this.current = this.current.next;
                    }
                    return this.next;
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    protected static class Entry {
        final long key;
        Object value;
        Entry next;

        protected Entry(long l, Object object, Entry entry) {
            this.key = l;
            this.value = object;
            this.next = entry;
        }
    }
}

