/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.util.AbstractCollection;
import java.util.Iterator;
import weblogic.utils.collections.CombinedIterator;
import weblogic.utils.collections.Pool;
import weblogic.utils.collections.StackPool;

public class PartitionedStackPool
extends AbstractCollection
implements Pool {
    private final StackPool[] pools;
    private int nextPool = 0;

    public PartitionedStackPool(int n) {
        this(n, 11);
    }

    public PartitionedStackPool(int n, int n2) {
        this.pools = new StackPool[n2];
        int n3 = n / this.pools.length;
        for (int i = 0; i < this.pools.length; ++i) {
            this.pools[i] = new StackPool(n3);
        }
    }

    public int size() {
        int n = 0;
        for (int i = 0; i < this.pools.length; ++i) {
            n += this.pools[i].size();
        }
        return n;
    }

    public Iterator iterator() {
        Iterator[] iteratorArray = new Iterator[this.pools.length];
        for (int i = 0; i < this.pools.length; ++i) {
            iteratorArray[i] = this.pools[i].iterator();
        }
        return new CombinedIterator(iteratorArray);
    }

    public boolean add(Object object) {
        this.nextPool = (this.nextPool + 1) % this.pools.length;
        return this.pools[this.nextPool].add(object);
    }

    public Object remove() {
        this.nextPool = (this.nextPool + 1) % this.pools.length;
        return this.pools[this.nextPool].remove();
    }
}

