/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.util.AbstractCollection;
import java.util.Iterator;
import weblogic.utils.collections.ArrayIterator;
import weblogic.utils.collections.FilteringIterator;
import weblogic.utils.collections.Pool;

public class StackPool
extends AbstractCollection
implements Pool {
    private final int capacity;
    private int pointer;
    private final Object[] values;

    public StackPool(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = n;
        this.values = new Object[this.capacity];
        this.pointer = 0;
    }

    protected int getPointer() {
        return this.pointer;
    }

    protected void setPointer(int n) {
        this.pointer = n;
    }

    protected Object getValueAt(int n) {
        return this.values[n];
    }

    protected Object decrementPointerAndGetValue() {
        return this.values[--this.pointer];
    }

    protected void setValueAt(int n, Object object) {
        this.values[n] = object;
    }

    public int size() {
        return this.pointer;
    }

    public int capacity() {
        return this.capacity;
    }

    public Iterator iterator() {
        return new FilteringIterator(new ArrayIterator(this.values)){

            protected boolean accept(Object object) {
                return object != null;
            }
        };
    }

    public synchronized boolean add(Object object) {
        if (this.pointer == this.capacity) {
            return false;
        }
        this.values[this.pointer++] = object;
        return true;
    }

    public synchronized Object remove() {
        if (this.pointer > 0) {
            Object object = this.values[--this.pointer];
            this.values[this.pointer] = null;
            return object;
        }
        return null;
    }
}

