/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.enumerations;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import weblogic.utils.enumerations.EmptyFileContainerException;
import weblogic.utils.enumerations.FIFO_FileContainer;
import weblogic.utils.enumerations.FileContainer;
import weblogic.utils.enumerations.LIFO_FileContainer;

public class FileEnumeration
implements Enumeration {
    public static final boolean DEPTH_FIRST = true;
    public static final boolean BREADTH_FIRST = false;
    private File nextFile;
    private boolean depthFirst = true;
    private FileContainer fileContainer;
    public boolean includeDirectories = true;
    public FilenameFilter filter = null;

    private FileContainer getFileContainer() {
        if (this.depthFirst) {
            return new LIFO_FileContainer();
        }
        return new FIFO_FileContainer();
    }

    public boolean getIncludeDirectories() {
        return this.includeDirectories;
    }

    public void setIncludeDirectories(boolean bl) {
        this.includeDirectories = bl;
    }

    public FileEnumeration() {
    }

    public FileEnumeration(boolean bl) {
        this.depthFirst = bl;
    }

    public FileEnumeration(File file) throws FileNotFoundException {
        this.resetTopDir(file);
    }

    public FileEnumeration(File file, boolean bl) throws FileNotFoundException {
        this.depthFirst = bl;
        this.resetTopDir(file);
    }

    public FileEnumeration(File file, FilenameFilter filenameFilter, boolean bl) throws FileNotFoundException {
        this.filter = filenameFilter;
        this.depthFirst = bl;
        this.resetTopDir(file);
    }

    public void setFilter(FilenameFilter filenameFilter) {
        this.filter = filenameFilter;
    }

    public void includeDirectories(boolean bl) {
        this.includeDirectories = bl;
    }

    public void setDepthFirst() {
        this.depthFirst = true;
    }

    public void setBreadthFirst() {
        this.depthFirst = false;
    }

    public void reset(File file) throws FileNotFoundException {
        this.resetTopDir(file);
    }

    public void resetTopDir(File file) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException("No such directory: " + file);
        }
        if (!file.isDirectory()) {
            throw new FileNotFoundException(file + " not a directory.");
        }
        this.fileContainer = this.getFileContainer();
        this.fileContainer.push(file);
    }

    public synchronized boolean hasMoreFiles() {
        if (this.nextFile == null) {
            this.nextFile = this.getNextFile();
        }
        return this.nextFile != null;
    }

    public synchronized File nextFile() {
        return this.next();
    }

    public synchronized File next() {
        if (this.nextFile == null) {
            this.nextFile = this.getNextFile();
        }
        if (this.nextFile == null) {
            throw new NoSuchElementException();
        }
        File file = this.nextFile;
        this.nextFile = null;
        return file;
    }

    public boolean hasMoreElements() {
        return this.hasMoreFiles();
    }

    public Object nextElement() {
        return this.nextFile();
    }

    private File getNextFile() {
        try {
            Object object;
            File file;
            File file2 = this.fileContainer.next();
            if (file2.isDirectory()) {
                file = file2;
                object = file.list();
                if (this.depthFirst) {
                    for (int i = ((String[])object).length - 1; i >= 0; --i) {
                        this.fileContainer.push(new File(file, object[i]));
                    }
                } else {
                    for (int i = 0; i < ((String[])object).length; ++i) {
                        this.fileContainer.push(new File(file, object[i]));
                    }
                }
                if (!this.includeDirectories && (file2 = this.getNextFile()) == null) {
                    return file2;
                }
            }
            if (this.filter == null) {
                return file2;
            }
            if (file2.isDirectory()) {
                file = file2;
                object = "";
            } else {
                file = new File(file2.getParent());
                object = file2.getName();
            }
            return this.filter.accept(file, (String)object) ? file2 : this.getNextFile();
        }
        catch (EmptyFileContainerException emptyFileContainerException) {
            return null;
        }
    }
}

