/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.http;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import weblogic.utils.Debug;
import weblogic.utils.io.Chunk;

public class HttpChunkOutputStream
extends FilterOutputStream {
    private final int httpChunkSize;
    private int chunkCount;
    private final Chunk head;
    private Chunk cur;
    private boolean isClosed;
    private static boolean DEBUG = false;
    private static int CHUNK_HEADER_SIZE = 6;
    private static int CHUNK_TAIL_SIZE = 2;
    private static byte CR = (byte)13;
    private static byte LF = (byte)10;
    private static byte[] HEX_DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    public HttpChunkOutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, Chunk.CHUNK_SIZE - CHUNK_HEADER_SIZE - CHUNK_TAIL_SIZE);
    }

    public HttpChunkOutputStream(OutputStream outputStream, int n) throws IOException {
        super(outputStream);
        if (n > 65536) {
            throw new IOException("chunk size should be less than 64k");
        }
        this.httpChunkSize = n;
        this.head = Chunk.getChunk();
        this.initChunkHead();
        if (DEBUG) {
            Debug.say("init " + n);
        }
    }

    private void initChunkHead() {
        this.cur = this.head;
        this.cur.end = CHUNK_HEADER_SIZE;
        this.chunkCount = 0;
    }

    private int getByteCount() {
        return this.chunkCount * Chunk.CHUNK_SIZE + this.cur.end - CHUNK_HEADER_SIZE;
    }

    private int ensureCapacity() {
        if (this.cur.end < Chunk.CHUNK_SIZE) {
            return Chunk.CHUNK_SIZE - this.cur.end;
        }
        if (this.cur.next == null) {
            this.cur.next = Chunk.getChunk();
        } else {
            this.cur.next.end = 0;
        }
        this.cur = this.cur.next;
        ++this.chunkCount;
        if (DEBUG) {
            Debug.say("adding chunk chunkCount=" + this.chunkCount);
        }
        return Chunk.CHUNK_SIZE;
    }

    public void write(int n) throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream is closed");
        }
        this.ensureCapacity();
        this.cur.buf[this.cur.end++] = (byte)n;
        if (this.getByteCount() == this.httpChunkSize) {
            this.flush();
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    private void writeToChunks(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        do {
            int n4;
            int n5 = n3 = n2 <= (n4 = this.ensureCapacity()) ? n2 : n4;
            if (DEBUG) {
                Debug.say(" off= " + n + " len=" + n2 + " toWrite=" + n3 + " cur.end=" + this.cur.end);
            }
            System.arraycopy(byArray, n, this.cur.buf, this.cur.end, n3);
            this.cur.end += n3;
            n += n3;
        } while ((n2 -= n3) > 0);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream is closed");
        }
        int n3 = this.httpChunkSize - this.getByteCount();
        if (DEBUG) {
            Debug.say("direct write off=" + n + " len=" + n2 + " bytes2flush=" + n3);
        }
        if (n2 < n3) {
            this.writeToChunks(byArray, n, n2);
            return;
        }
        do {
            this.writeToChunks(byArray, n, n3);
            n += n3;
            if ((n2 -= n3) > 0) {
                this.flush();
                n3 = this.httpChunkSize - this.getByteCount();
                if (n2 < n3) {
                    n3 = n2;
                }
            }
            if (!DEBUG) continue;
            Debug.say("flush write off=" + n + " len=" + n2 + " bytes2flush=" + n3);
        } while (n2 > 0);
    }

    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.flush();
        this.writeChunkHeader(0);
        this.head.buf[this.head.end++] = CR;
        this.head.buf[this.head.end++] = LF;
        this.out.write(this.head.buf, 0, this.head.end);
        this.out.flush();
        Chunk.releaseChunks(this.head);
        this.isClosed = true;
    }

    private void writeChunkHeader(int n) {
        int n2 = 4;
        do {
            this.head.buf[--n2] = HEX_DIGITS[n & 0xF];
        } while ((n >>>= 4) != 0);
        for (int i = 0; i < n2; ++i) {
            this.head.buf[i] = 48;
        }
        this.head.buf[4] = CR;
        this.head.buf[5] = LF;
        if (DEBUG) {
            Debug.say("chunk header 0x" + new String(this.head.buf, 0, 4));
        }
    }

    public void flush() throws IOException {
        int n = this.getByteCount();
        if (this.isClosed || n == 0) {
            return;
        }
        this.writeChunkHeader(n);
        this.ensureCapacity();
        this.cur.buf[this.cur.end++] = CR;
        this.ensureCapacity();
        this.cur.buf[this.cur.end++] = LF;
        Chunk chunk = this.head;
        while (chunk != null) {
            this.out.write(chunk.buf, 0, chunk.end);
            if (DEBUG) {
                Debug.say("flush writing bytes " + chunk.end);
            }
            if (chunk == this.cur) break;
            chunk = chunk.next;
        }
        this.out.flush();
        this.initChunkHead();
    }
}

