/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import weblogic.utils.io.ByteBufferOutputStream;
import weblogic.utils.io.DataIO;
import weblogic.utils.io.StringOutput;

public class ByteBufferDataOutputStream
extends ByteBufferOutputStream
implements DataOutput,
StringOutput {
    public void writeBoolean(boolean bl) throws IOException {
        this.write(bl ? 1 : 0);
    }

    public void writeByte(int n) throws IOException {
        this.write(n);
    }

    public void writeShort(int n) throws IOException {
        if (this.currentBuffer.remaining() >= 2) {
            this.currentBuffer.putShort((short)n);
        } else {
            DataIO.writeShort(this, n);
        }
    }

    public void writeChar(int n) throws IOException {
        if (this.currentBuffer.remaining() >= 2) {
            this.currentBuffer.putChar((char)n);
        } else {
            DataIO.writeChar(this, n);
        }
    }

    public void writeInt(int n) throws IOException {
        if (this.currentBuffer.remaining() >= 4) {
            this.currentBuffer.putInt(n);
        } else {
            DataIO.writeInt(this, n);
        }
    }

    public void writeLong(long l) throws IOException {
        if (this.currentBuffer.remaining() >= 8) {
            this.currentBuffer.putLong(l);
        } else {
            DataIO.writeLong(this, l);
        }
    }

    public void writeFloat(float f) throws IOException {
        if (this.currentBuffer.remaining() >= 4) {
            this.currentBuffer.putFloat(f);
        } else {
            DataIO.writeFloat(this, f);
        }
    }

    public void writeDouble(double d) throws IOException {
        if (this.currentBuffer.remaining() >= 8) {
            this.currentBuffer.putDouble(d);
        } else {
            DataIO.writeDouble(this, d);
        }
    }

    public final void writeBytes(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.write((byte)string.charAt(i));
        }
    }

    public final void writeChars(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            this.writeChar(c);
        }
    }

    public void writeUTF(String string) throws IOException {
        DataIO.writeUTF((OutputStream)this, string);
    }

    public void writeASCII(String string) throws IOException {
        DataIO.writeASCII(this, string);
    }

    public void writeUTF8(String string) throws IOException {
        DataIO.writeUTF8(this, string);
    }
}

