/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ByteBufferOutputStream
extends OutputStream {
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private final int bufferSize;
    protected ByteBuffer currentBuffer;
    private ByteBuffer[] buffers;

    public ByteBufferOutputStream() {
        this(1024);
    }

    public ByteBufferOutputStream(int n) {
        this.bufferSize = n;
        this.currentBuffer = ByteBuffer.allocate(n);
        this.buffers = new ByteBuffer[]{this.currentBuffer};
    }

    public final void write(int n) throws IOException {
        if (this.currentBuffer.remaining() < 1) {
            this.expand();
        }
        this.currentBuffer.put((byte)n);
    }

    public final void write(byte[] byArray, int n, int n2) {
        while (true) {
            int n3 = this.currentBuffer.remaining();
            int n4 = Math.min(n3, n2);
            this.currentBuffer.put(byArray, n, n4);
            n += n4;
            if ((n2 -= n4) <= 0) break;
            this.expand();
        }
    }

    private final void expand() {
        ByteBuffer[] byteBufferArray = new ByteBuffer[this.buffers.length + 1];
        System.arraycopy(this.buffers, 0, byteBufferArray, 0, this.buffers.length);
        this.buffers = byteBufferArray;
        this.buffers[this.buffers.length - 1] = this.currentBuffer = ByteBuffer.allocate(this.bufferSize);
    }

    public ByteBuffer[] getBuffers() throws IOException {
        this.flush();
        for (int i = 0; i < this.buffers.length; ++i) {
            this.buffers[i].flip();
        }
        return this.buffers;
    }
}

