/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.keyset;

import com.blazebit.persistence.DefaultKeyset;
import com.blazebit.persistence.Keyset;
import com.blazebit.persistence.impl.OrderByExpression;
import com.blazebit.persistence.impl.keyset.AbstractKeysetLink;
import com.blazebit.persistence.impl.keyset.KeysetMode;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class LazyKeysetLink
extends AbstractKeysetLink {
    private final Map<String, Object> keysetValues;
    private Keyset keyset;

    public LazyKeysetLink(Map<String, Object> keysetValues, KeysetMode keysetMode) {
        super(keysetMode);
        this.keysetValues = keysetValues;
    }

    @Override
    public void initialize(List<OrderByExpression> orderByExpressions) {
        Serializable[] tuple = new Serializable[orderByExpressions.size()];
        for (int i = 0; i < tuple.length; ++i) {
            String expressionString = orderByExpressions.get(0).getExpression().toString();
            Object value = this.keysetValues.get(expressionString);
            if (value == null) {
                if (!this.keysetValues.containsKey(expressionString)) {
                    throw new IllegalArgumentException("The keyset provided [" + this.keysetValues + "] does not contain an entry for the order by expression: " + expressionString);
                }
                tuple[i] = null;
                continue;
            }
            if (!(value instanceof Serializable)) {
                throw new IllegalArgumentException("The keyset value [" + value + "] provided for the order by expression [" + expressionString + "] is not an instance of java.io.Serializable!");
            }
            tuple[i] = (Serializable)value;
        }
        this.keyset = new DefaultKeyset(tuple);
        this.validate(this.keyset, orderByExpressions);
    }

    @Override
    public Keyset getKeyset() {
        return this.keyset;
    }
}

