/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser.expression;

import com.blazebit.persistence.parser.expression.AbstractExpression;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionCopyContext;
import com.blazebit.persistence.parser.expression.LiteralExpression;

public class EntityLiteral
extends AbstractExpression
implements LiteralExpression<Class<?>> {
    private final Class<?> value;
    private final String originalExpression;

    public EntityLiteral(Class<?> value, String originalExpression) {
        this.value = value;
        this.originalExpression = originalExpression;
    }

    @Override
    public Class<?> getValue() {
        return this.value;
    }

    public String getOriginalExpression() {
        return this.originalExpression;
    }

    @Override
    public Expression copy(ExpressionCopyContext copyContext) {
        return new EntityLiteral(this.value, this.originalExpression);
    }

    @Override
    public void accept(Expression.Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(Expression.ResultVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityLiteral)) {
            return false;
        }
        EntityLiteral that = (EntityLiteral)o;
        return this.value != null ? this.value.equals(that.value) : that.value == null;
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    @Override
    public String toString() {
        return this.originalExpression;
    }
}

