/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser.util;

import com.blazebit.persistence.parser.expression.ArrayExpression;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.PathElementExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.PropertyExpression;
import com.blazebit.persistence.parser.expression.QualifiedExpression;
import com.blazebit.persistence.parser.expression.TreatExpression;

public class ExpressionUtils {
    private ExpressionUtils() {
    }

    public static boolean isSizeFunction(Expression expression) {
        if (expression instanceof FunctionExpression) {
            return ExpressionUtils.isSizeFunction((FunctionExpression)expression);
        }
        return false;
    }

    public static boolean isSizeFunction(FunctionExpression expression) {
        return "SIZE".equalsIgnoreCase(expression.getFunctionName());
    }

    public static boolean isOuterFunction(FunctionExpression e) {
        return "OUTER".equalsIgnoreCase(e.getFunctionName());
    }

    public static boolean isCustomFunctionInvocation(FunctionExpression e) {
        return "FUNCTION".equalsIgnoreCase(e.getFunctionName());
    }

    public static boolean isCountFunction(Expression expression) {
        if (expression instanceof FunctionExpression) {
            return ExpressionUtils.isCountFunction((FunctionExpression)expression);
        }
        return false;
    }

    public static boolean isCountFunction(FunctionExpression expr) {
        return "COUNT".equalsIgnoreCase(expr.getFunctionName());
    }

    public static PathExpression getLeftMostPathExpression(PathExpression leftMost) {
        PathElementExpression pathElementExpression;
        while (!((pathElementExpression = leftMost.getExpressions().get(0)) instanceof PropertyExpression)) {
            if (pathElementExpression instanceof TreatExpression) {
                Expression treatPath = ((TreatExpression)pathElementExpression).getExpression();
                if (treatPath instanceof QualifiedExpression) {
                    leftMost = ((QualifiedExpression)((Object)treatPath)).getPath();
                    continue;
                }
                leftMost = (PathExpression)treatPath;
                continue;
            }
            if (pathElementExpression instanceof QualifiedExpression) {
                leftMost = ((QualifiedExpression)((Object)pathElementExpression)).getPath();
                continue;
            }
            if (pathElementExpression instanceof ArrayExpression) break;
            throw new IllegalArgumentException("Unsupported expression: " + pathElementExpression);
        }
        return leftMost;
    }
}

