/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser.expression;

import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionCopyContext;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.OrderByItem;
import com.blazebit.persistence.parser.expression.WindowDefinition;
import com.blazebit.persistence.parser.predicate.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AggregateExpression
extends FunctionExpression {
    private boolean distinct;

    public AggregateExpression(boolean distinct, String functionName, List<Expression> expressions) {
        super(functionName, expressions);
        this.distinct = distinct;
    }

    public AggregateExpression(boolean distinct, String functionName, List<Expression> expressions, List<OrderByItem> withinGroup, Predicate filterPredicate) {
        super(functionName, expressions, withinGroup, filterPredicate == null ? null : new WindowDefinition(null, filterPredicate));
        this.distinct = distinct;
    }

    @Override
    public AggregateExpression copy(ExpressionCopyContext copyContext) {
        ArrayList<OrderByItem> newWithinGroup;
        List<Expression> newExpressions;
        int size = this.expressions.size();
        if (size == 0) {
            newExpressions = Collections.emptyList();
        } else {
            newExpressions = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                newExpressions.add(((Expression)this.expressions.get(i)).copy(copyContext));
            }
        }
        if (this.withinGroup == null) {
            newWithinGroup = null;
        } else {
            size = this.withinGroup.size();
            newWithinGroup = new ArrayList<OrderByItem>(size);
            for (int i = 0; i < size; ++i) {
                newWithinGroup.add(((OrderByItem)this.withinGroup.get(i)).copy(copyContext));
            }
        }
        return new AggregateExpression(this.distinct, this.functionName, newExpressions, newWithinGroup, this.windowDefinition == null ? null : this.windowDefinition.getFilterPredicate().copy(copyContext));
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }
}

