/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser.expression;

import com.blazebit.persistence.parser.expression.AbstractExpression;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionCopyContext;
import com.blazebit.persistence.parser.expression.OrderByItem;
import com.blazebit.persistence.parser.expression.WindowDefinition;
import java.util.ArrayList;
import java.util.List;

public class FunctionExpression
extends AbstractExpression {
    protected final String functionName;
    protected final WindowDefinition windowDefinition;
    protected final Expression realArgument;
    protected List<Expression> expressions;
    protected List<OrderByItem> withinGroup;
    protected WindowDefinition resolvedWindowDefinition;

    public FunctionExpression(String functionName, List<? extends Expression> expressions) {
        this.functionName = functionName;
        this.expressions = expressions;
        this.realArgument = null;
        this.windowDefinition = null;
    }

    public FunctionExpression(String functionName, List<? extends Expression> expressions, Expression realArgument) {
        this.functionName = functionName;
        this.expressions = expressions;
        this.realArgument = realArgument;
        this.windowDefinition = null;
    }

    public FunctionExpression(String functionName, List<? extends Expression> expressions, List<OrderByItem> withinGroup, WindowDefinition windowDefinition) {
        this.functionName = functionName;
        this.expressions = expressions;
        this.realArgument = null;
        this.withinGroup = withinGroup;
        this.windowDefinition = windowDefinition;
    }

    private FunctionExpression(String functionName, List<? extends Expression> expressions, Expression realArgument, List<OrderByItem> withinGroup, WindowDefinition windowDefinition) {
        this.functionName = functionName;
        this.expressions = expressions;
        this.realArgument = realArgument;
        this.withinGroup = withinGroup;
        this.windowDefinition = windowDefinition;
    }

    @Override
    public FunctionExpression copy(ExpressionCopyContext copyContext) {
        ArrayList<OrderByItem> newWithinGroup;
        int size = this.expressions.size();
        ArrayList<Expression> newExpressions = new ArrayList<Expression>(size);
        for (int i = 0; i < size; ++i) {
            newExpressions.add(this.expressions.get(i).copy(copyContext));
        }
        if (this.withinGroup == null) {
            newWithinGroup = null;
        } else {
            size = this.withinGroup.size();
            newWithinGroup = new ArrayList<OrderByItem>(size);
            for (int i = 0; i < size; ++i) {
                newWithinGroup.add(this.withinGroup.get(i).copy(copyContext));
            }
        }
        return new FunctionExpression(this.functionName, newExpressions, this.realArgument == null ? null : this.realArgument.copy(copyContext), newWithinGroup, this.windowDefinition == null ? null : this.windowDefinition.copy(copyContext));
    }

    @Override
    public void accept(Expression.Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(Expression.ResultVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public Expression getRealArgument() {
        return this.realArgument;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public void setExpressions(List<Expression> expressions) {
        this.expressions = expressions;
    }

    public List<OrderByItem> getWithinGroup() {
        return this.withinGroup;
    }

    public void setWithinGroup(List<OrderByItem> withinGroup) {
        this.withinGroup = withinGroup;
    }

    public WindowDefinition getWindowDefinition() {
        return this.windowDefinition;
    }

    public WindowDefinition getResolvedWindowDefinition() {
        return this.resolvedWindowDefinition;
    }

    public void setResolvedWindowDefinition(WindowDefinition resolvedWindowDefinition) {
        this.resolvedWindowDefinition = resolvedWindowDefinition;
    }

    public int hashCode() {
        return this.functionName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionExpression other = (FunctionExpression)obj;
        if (this.functionName == null ? other.functionName != null : !this.functionName.equals(other.functionName)) {
            return false;
        }
        return this.expressions == other.expressions || this.expressions != null && this.expressions.equals(other.expressions);
    }
}

