/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser.expression;

import com.blazebit.persistence.parser.expression.MacroFunction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class MacroConfiguration {
    final Map<String, MacroFunction> macros;
    final int hash;

    private MacroConfiguration(Map<String, MacroFunction> macros) {
        this.macros = Collections.unmodifiableMap(macros);
        this.hash = macros == null ? 0 : macros.hashCode();
    }

    public static MacroConfiguration of(Map<String, MacroFunction> macros) {
        HashMap<String, MacroFunction> map = new HashMap<String, MacroFunction>(macros.size());
        for (Map.Entry<String, MacroFunction> entry : macros.entrySet()) {
            map.put(entry.getKey().toUpperCase(), entry.getValue());
        }
        return new MacroConfiguration(map);
    }

    public MacroFunction get(String name) {
        return this.macros.get(name);
    }

    public MacroConfiguration with(Map<String, MacroFunction> newMacros) {
        HashMap<String, MacroFunction> map = new HashMap<String, MacroFunction>(this.macros.size() + newMacros.size());
        map.putAll(this.macros);
        for (Map.Entry<String, MacroFunction> entry : newMacros.entrySet()) {
            if (entry.getValue() == null) {
                map.remove(entry.getKey().toUpperCase());
                continue;
            }
            map.put(entry.getKey().toUpperCase(), entry.getValue());
        }
        return new MacroConfiguration(map);
    }

    public Map<String, MacroFunction> getMacros() {
        return this.macros;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MacroConfiguration)) {
            return false;
        }
        MacroConfiguration that = (MacroConfiguration)o;
        return this.hash == that.hash && this.macros.equals(that.macros);
    }

    public int hashCode() {
        return this.hash;
    }
}

