/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser.predicate;

import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionCopyContext;
import com.blazebit.persistence.parser.predicate.AbstractPredicate;
import com.blazebit.persistence.parser.predicate.Predicate;

public class BooleanLiteral
extends AbstractPredicate {
    private final boolean value;

    public BooleanLiteral(boolean value) {
        super(false);
        this.value = value;
    }

    public BooleanLiteral(boolean value, boolean negated) {
        super(negated);
        this.value = value;
    }

    public boolean getValue() {
        return this.value;
    }

    @Override
    public Predicate copy(ExpressionCopyContext copyContext) {
        return new BooleanLiteral(this.value, this.negated);
    }

    @Override
    public void accept(Expression.Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(Expression.ResultVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BooleanLiteral)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BooleanLiteral that = (BooleanLiteral)o;
        return this.value == that.value;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.value ? 1 : 0);
        return result;
    }

    @Override
    public String toString() {
        return Boolean.toString(this.value != this.negated);
    }
}

