/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser.util;

import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.reflection.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;

public class JpaMetamodelUtils {
    public static final Comparator<EntityType<?>> ENTITY_NAME_COMPARATOR = new Comparator<EntityType<?>>(){

        @Override
        public int compare(EntityType<?> o1, EntityType<?> o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    public static final Comparator<Attribute<?, ?>> ATTRIBUTE_NAME_COMPARATOR = new Comparator<Attribute<?, ?>>(){

        @Override
        public int compare(Attribute<?, ?> o1, Attribute<?, ?> o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };

    private JpaMetamodelUtils() {
    }

    public static String getTypeName(Type<?> type) {
        if (type.getJavaType() == null || type instanceof EntityType) {
            return ((EntityType)type).getName();
        }
        return type.getJavaType().getName();
    }

    public static String getSimpleTypeName(Type<?> type) {
        if (type.getJavaType() == null || type instanceof EntityType) {
            return ((EntityType)type).getName();
        }
        return type.getJavaType().getSimpleName();
    }

    public static Class<?> resolveType(Class<?> concreteClass, java.lang.reflect.Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof TypeVariable) {
            return JpaMetamodelUtils.resolveType(concreteClass, ((TypeVariable)type).getBounds()[0]);
        }
        throw new IllegalArgumentException("Unsupported type for resolving: " + type);
    }

    private static Class<?> getConcreterClass(Class<?> class1, Class<?> class2) {
        if (class1.isAssignableFrom(class2)) {
            return class2;
        }
        if (class2.isAssignableFrom(class1)) {
            return class1;
        }
        throw new IllegalArgumentException("The classes [" + class1.getName() + ", " + class2.getName() + "] are not in a inheritance relationship, so there is no concreter class!");
    }

    public static Class<?> resolveKeyClass(Class<?> baseClass, MapAttribute<?, ?, ?> attr) {
        Class<?> fieldClass;
        Class<?> resolverBaseClass = baseClass == null ? null : JpaMetamodelUtils.getConcreterClass(baseClass, attr.getDeclaringType().getJavaType());
        Class<?> jpaReportedFieldClass = fieldClass = attr.getKeyType().getJavaType();
        if (resolverBaseClass == null) {
            return jpaReportedFieldClass;
        }
        if (attr.getJavaMember() instanceof Method) {
            Method method = (Method)attr.getJavaMember();
            Class[] typeArguments = ReflectionUtils.getResolvedMethodReturnTypeArguments(resolverBaseClass, (Method)method);
            if (typeArguments.length != 0 && (fieldClass = typeArguments[0]) == null) {
                fieldClass = JpaMetamodelUtils.resolveType(resolverBaseClass, ((ParameterizedType)method.getGenericReturnType()).getActualTypeArguments()[0]);
            }
        } else {
            Field field = (Field)attr.getJavaMember();
            Class[] typeArguments = ReflectionUtils.getResolvedFieldTypeArguments(resolverBaseClass, (Field)field);
            if (typeArguments.length != 0 && (fieldClass = typeArguments[0]) == null) {
                fieldClass = JpaMetamodelUtils.resolveType(resolverBaseClass, ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]);
            }
        }
        if (fieldClass.isAssignableFrom(jpaReportedFieldClass)) {
            return jpaReportedFieldClass;
        }
        if (jpaReportedFieldClass.isAssignableFrom(fieldClass)) {
            return fieldClass;
        }
        return fieldClass;
    }

    public static Class<?> resolveFieldClass(Class<?> baseClass, Attribute<?, ?> attr) {
        Class jpaReportedFieldClass;
        Class<?> fieldClass;
        Class<?> resolverBaseClass;
        Class<?> clazz = resolverBaseClass = baseClass == null ? null : JpaMetamodelUtils.getConcreterClass(baseClass, attr.getDeclaringType().getJavaType());
        if (attr instanceof PluralAttribute) {
            PluralAttribute collectionAttr = (PluralAttribute)attr;
            fieldClass = collectionAttr.getElementType().getJavaType();
            jpaReportedFieldClass = fieldClass;
            if (resolverBaseClass == null) {
                return jpaReportedFieldClass;
            }
            if (collectionAttr.getCollectionType() == PluralAttribute.CollectionType.MAP) {
                if (attr.getJavaMember() instanceof Method) {
                    Method method = (Method)attr.getJavaMember();
                    Class[] typeArguments = ReflectionUtils.getResolvedMethodReturnTypeArguments(resolverBaseClass, (Method)method);
                    if (typeArguments.length != 0 && (fieldClass = typeArguments[1]) == null) {
                        fieldClass = JpaMetamodelUtils.resolveType(resolverBaseClass, ((ParameterizedType)method.getGenericReturnType()).getActualTypeArguments()[1]);
                    }
                } else {
                    Field field = (Field)attr.getJavaMember();
                    Class[] typeArguments = ReflectionUtils.getResolvedFieldTypeArguments(resolverBaseClass, (Field)field);
                    if (typeArguments.length != 0 && (fieldClass = typeArguments[1]) == null) {
                        fieldClass = JpaMetamodelUtils.resolveType(resolverBaseClass, ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[1]);
                    }
                }
            } else if (attr.getJavaMember() instanceof Method) {
                Method method = (Method)attr.getJavaMember();
                Class[] typeArguments = ReflectionUtils.getResolvedMethodReturnTypeArguments(resolverBaseClass, (Method)method);
                if (typeArguments.length != 0 && (fieldClass = typeArguments[0]) == null) {
                    fieldClass = JpaMetamodelUtils.resolveType(resolverBaseClass, ((ParameterizedType)method.getGenericReturnType()).getActualTypeArguments()[0]);
                }
            } else {
                Field field = (Field)attr.getJavaMember();
                Class[] typeArguments = ReflectionUtils.getResolvedFieldTypeArguments(resolverBaseClass, (Field)field);
                if (typeArguments.length != 0 && (fieldClass = typeArguments[0]) == null) {
                    fieldClass = JpaMetamodelUtils.resolveType(resolverBaseClass, ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]);
                }
            }
        } else {
            jpaReportedFieldClass = ((SingularAttribute)attr).getType().getJavaType();
            if (attr.getJavaType().isArray() && attr.getJavaType().getComponentType() == jpaReportedFieldClass) {
                jpaReportedFieldClass = attr.getJavaType();
            }
            if (resolverBaseClass == null) {
                return jpaReportedFieldClass;
            }
            if (attr.getJavaMember() instanceof Method) {
                Method method = (Method)attr.getJavaMember();
                if (!method.getName().startsWith("get") && !method.getName().startsWith("is")) {
                    return jpaReportedFieldClass;
                }
                Class<?> fieldClass2 = ReflectionUtils.getResolvedMethodReturnType(resolverBaseClass, (Method)method);
                if (fieldClass2 == null) {
                    fieldClass2 = JpaMetamodelUtils.resolveType(resolverBaseClass, method.getGenericReturnType());
                }
                if (fieldClass2.isAssignableFrom(jpaReportedFieldClass)) {
                    return jpaReportedFieldClass;
                }
                if (jpaReportedFieldClass.isAssignableFrom(fieldClass2)) {
                    return fieldClass2;
                }
                if (method.getGenericReturnType() instanceof TypeVariable) {
                    return fieldClass2;
                }
                return jpaReportedFieldClass;
            }
            if (attr.getJavaMember() instanceof Field) {
                Field field = (Field)attr.getJavaMember();
                Class<?> fieldClass3 = ReflectionUtils.getResolvedFieldType(resolverBaseClass, (Field)field);
                if (fieldClass3 == null) {
                    fieldClass3 = JpaMetamodelUtils.resolveType(resolverBaseClass, field.getGenericType());
                }
                if (fieldClass3.isAssignableFrom(jpaReportedFieldClass)) {
                    return jpaReportedFieldClass;
                }
                if (jpaReportedFieldClass.isAssignableFrom(fieldClass3)) {
                    return fieldClass3;
                }
                if (field.getGenericType() instanceof TypeVariable) {
                    return fieldClass3;
                }
                return jpaReportedFieldClass;
            }
            fieldClass = jpaReportedFieldClass;
        }
        if (fieldClass.isAssignableFrom(jpaReportedFieldClass)) {
            return jpaReportedFieldClass;
        }
        if (jpaReportedFieldClass.isAssignableFrom(fieldClass)) {
            return fieldClass;
        }
        return fieldClass;
    }

    public static <T> Attribute<? super T, ?> getAttribute(ManagedType<T> type, String attributeName) {
        try {
            return type.getAttribute(attributeName);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static SingularAttribute<?, ?> getSingleIdAttribute(IdentifiableType<?> entityType) {
        Iterator<SingularAttribute<?, ?>> iterator = JpaMetamodelUtils.getIdAttributes(entityType).iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        SingularAttribute<?, ?> next = iterator.next();
        if (iterator.hasNext()) {
            ArrayList<String> attributes = new ArrayList<String>();
            attributes.add(next.getName());
            do {
                attributes.add(iterator.next().getName());
            } while (iterator.hasNext());
            throw new IllegalStateException("Can't retrieve a single id attribute as the entity " + entityType.getJavaType().getName() + " has multiple id attributes: " + attributes);
        }
        return next;
    }

    public static Set<SingularAttribute<?, ?>> getIdAttributes(IdentifiableType<?> entityType) {
        try {
            if (entityType.hasSingleIdAttribute()) {
                return Collections.singleton(entityType.getId(entityType.getIdType().getJavaType()));
            }
            if (entityType.getIdType() == null) {
                return JpaMetamodelUtils.collectIdAttributes(entityType);
            }
            TreeSet idTypes = new TreeSet(ATTRIBUTE_NAME_COMPARATOR);
            idTypes.addAll(entityType.getIdClassAttributes());
            return idTypes;
        }
        catch (IllegalArgumentException e) {
            if (entityType.getIdType() != null) {
                Class primitiveIdClass = ReflectionUtils.getPrimitiveClassOfWrapper((Class)entityType.getIdType().getJavaType());
                if (primitiveIdClass == null) {
                    Set<SingularAttribute<?, ?>> idTypes = JpaMetamodelUtils.collectIdAttributes(entityType);
                    if (!idTypes.isEmpty()) {
                        return idTypes;
                    }
                } else {
                    return Collections.singleton(entityType.getId(primitiveIdClass));
                }
            }
            throw e;
        }
        catch (IllegalStateException e) {
            Set<SingularAttribute<?, ?>> idTypes = JpaMetamodelUtils.collectIdAttributes(entityType);
            if (!idTypes.isEmpty()) {
                return idTypes;
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (e.getClass().getSimpleName().equals("ClassNotResolvedException")) {
                return Collections.emptySet();
            }
            if (e instanceof NullPointerException) {
                IdentifiableType identifiableType = entityType;
                while (identifiableType.getSupertype() instanceof IdentifiableType) {
                    try {
                        identifiableType = identifiableType.getSupertype();
                        return Collections.singleton(identifiableType.getId(identifiableType.getIdType().getJavaType()));
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                }
                throw e;
            }
            throw e;
        }
    }

    private static Set<SingularAttribute<?, ?>> collectIdAttributes(IdentifiableType<?> entityType) {
        TreeSet idTypes = new TreeSet(ATTRIBUTE_NAME_COMPARATOR);
        for (SingularAttribute attribute : entityType.getSingularAttributes()) {
            if (!attribute.isId()) continue;
            idTypes.add((Attribute<?, ?>)attribute);
        }
        return idTypes;
    }

    public static SingularAttribute<?, ?> getVersionAttribute(IdentifiableType<?> entityType) {
        if (!entityType.hasVersionAttribute()) {
            return null;
        }
        for (SingularAttribute attribute : entityType.getSingularAttributes()) {
            if (!attribute.isVersion()) continue;
            return attribute;
        }
        return null;
    }

    public static ManagedType<?> getManagedType(EntityMetamodel metamodel, Class<?> managedTypeClass, String treatTypeName) {
        if (treatTypeName != null) {
            ManagedType<?> type = metamodel.managedType(treatTypeName);
            if (!managedTypeClass.isAssignableFrom(type.getJavaType())) {
                throw new IllegalArgumentException("Treat type '" + treatTypeName + "' is not a subtype of: " + managedTypeClass.getName());
            }
            return type;
        }
        return metamodel.managedType(managedTypeClass);
    }

    public static boolean isMap(Attribute<?, ?> attr) {
        return attr instanceof MapAttribute;
    }

    public static boolean isOptional(Attribute<?, ?> attribute) {
        if (attribute instanceof SingularAttribute) {
            return ((SingularAttribute)attribute).isOptional();
        }
        return true;
    }

    public static List<String> getEmbeddedPropertyNames(EmbeddableType<?> embeddedType) {
        ArrayList<String> attributes = new ArrayList<String>();
        for (Attribute attribute : embeddedType.getAttributes()) {
            attributes.add(attribute.getName());
        }
        return attributes;
    }

    public static boolean isIdentifiable(ManagedType<?> jpaManagedType) {
        if (jpaManagedType instanceof IdentifiableType) {
            IdentifiableType identifiableType = (IdentifiableType)jpaManagedType;
            if (identifiableType.hasSingleIdAttribute()) {
                return true;
            }
            try {
                if (identifiableType.getIdType() != null) {
                    return true;
                }
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (RuntimeException ex) {
                try {
                    return !identifiableType.getIdClassAttributes().isEmpty();
                }
                catch (NullPointerException ex2) {
                    return true;
                }
            }
            try {
                return !identifiableType.getIdClassAttributes().isEmpty();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isAssociation(Attribute<?, ?> attr) {
        return attr.getPersistentAttributeType() == Attribute.PersistentAttributeType.MANY_TO_ONE || attr.getPersistentAttributeType() == Attribute.PersistentAttributeType.ONE_TO_ONE;
    }

    public static boolean isNullable(Attribute<?, ?> attr) {
        if (attr.isCollection()) {
            return true;
        }
        return ((SingularAttribute)attr).isOptional() && !((SingularAttribute)attr).isId();
    }
}

