/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.hibernate;

import com.blazebit.persistence.view.spi.TransactionAccess;
import com.blazebit.persistence.view.spi.TransactionSupport;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityTransaction;
import jakarta.transaction.Synchronization;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.resource.transaction.spi.SynchronizationRegistry;

public class Hibernate6EntityTransactionSynchronizationStrategy
implements TransactionAccess,
TransactionSupport {
    private final EntityTransaction tx;
    private final SynchronizationRegistry synchronizationRegistry;

    public Hibernate6EntityTransactionSynchronizationStrategy(EntityTransaction tx, EntityManager em) {
        this.tx = tx;
        Session s = (Session)em.unwrap(Session.class);
        this.synchronizationRegistry = ((SessionImplementor)s).getTransactionCoordinator().getLocalSynchronizations();
    }

    public boolean isActive() {
        return this.tx.isActive();
    }

    public void markRollbackOnly() {
        this.tx.setRollbackOnly();
    }

    public void registerSynchronization(Synchronization synchronization) {
        this.synchronizationRegistry.registerSynchronization(synchronization);
    }

    public void transactional(Runnable runnable) {
        runnable.run();
    }
}

