/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.hibernate;

import com.blazebit.persistence.integration.hibernate.StatementPreparerImpl;
import com.blazebit.persistence.integration.hibernate.base.HibernateReturningResult;
import com.blazebit.persistence.spi.DbmsDialect;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.jdbc.spi.StatementPreparer;
import org.hibernate.engine.spi.SessionFactoryImplementor;

public class JdbcCoordinatorInvocationHandler
implements InvocationHandler {
    private final JdbcCoordinator delegate;
    private final SessionFactoryImplementor sessionFactoryImplementor;
    private final DbmsDialect dbmsDialect;
    private final int[] returningSqlTypes;
    private final HibernateReturningResult<?> returningResult;
    private transient StatementPreparer statementPreparer;

    public JdbcCoordinatorInvocationHandler(JdbcCoordinator delegate, SessionFactoryImplementor sessionFactoryImplementor, DbmsDialect dbmsDialect, int[] returningSqlTypes, HibernateReturningResult<?> returningResult) {
        this.delegate = delegate;
        this.sessionFactoryImplementor = sessionFactoryImplementor;
        this.dbmsDialect = dbmsDialect;
        this.returningSqlTypes = returningSqlTypes;
        this.returningResult = returningResult;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("getStatementPreparer".equals(method.getName())) {
            if (this.statementPreparer == null) {
                this.statementPreparer = new StatementPreparerImpl(this.delegate, this.sessionFactoryImplementor, this.dbmsDialect, this.returningSqlTypes, this.returningResult);
            }
            return this.statementPreparer;
        }
        return method.invoke((Object)this.delegate, args);
    }
}

