/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.querydsl;

import com.blazebit.persistence.querydsl.DefaultVisitorImpl;
import com.blazebit.persistence.querydsl.JPQLNextOps;
import com.blazebit.persistence.querydsl.NotEmptySetVisitor;
import com.blazebit.persistence.querydsl.SetOperationFlag;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Operation;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.Visitor;

public final class SetUtils {
    protected SetUtils() {
    }

    @SafeVarargs
    public static <T> Expression<T> setOperation(JPQLNextOps setOperation, boolean wrapSets, Expression<T> ... expressions) {
        Expression result = expressions[0];
        SetOperationVisitor setOperationVisitor = new SetOperationVisitor(setOperation, wrapSets);
        for (int i = 1; i < expressions.length; ++i) {
            Expression<T> expression = expressions[i];
            if (!Boolean.TRUE.equals(expression.accept((Visitor)NotEmptySetVisitor.INSTANCE, null))) continue;
            result = (Expression)result.accept(setOperationVisitor, expression);
        }
        return result;
    }

    private static JPQLNextOps getLeftNestedSetOperation(JPQLNextOps setOperation) {
        switch (setOperation) {
            case SET_UNION: {
                return JPQLNextOps.LEFT_NESTED_SET_UNION;
            }
            case SET_UNION_ALL: {
                return JPQLNextOps.LEFT_NESTED_SET_UNION_ALL;
            }
            case SET_INTERSECT: {
                return JPQLNextOps.LEFT_NESTED_SET_INTERSECT;
            }
            case SET_INTERSECT_ALL: {
                return JPQLNextOps.LEFT_NESTED_SET_INTERSECT_ALL;
            }
            case SET_EXCEPT: {
                return JPQLNextOps.LEFT_NESTED_SET_EXCEPT;
            }
            case SET_EXCEPT_ALL: {
                return JPQLNextOps.LEFT_NESTED_SET_EXCEPT_ALL;
            }
        }
        return setOperation;
    }

    @SafeVarargs
    public static <T> Expression<T> union(Expression<T> ... expressions) {
        return SetUtils.setOperation(JPQLNextOps.SET_UNION, true, expressions);
    }

    @SafeVarargs
    public static <T> Expression<T> unionAll(Expression<T> ... expressions) {
        return SetUtils.setOperation(JPQLNextOps.SET_UNION_ALL, true, expressions);
    }

    @SafeVarargs
    public static <T> Expression<T> intersect(Expression<T> ... expressions) {
        return SetUtils.setOperation(JPQLNextOps.SET_INTERSECT, true, expressions);
    }

    @SafeVarargs
    public static <T> Expression<T> intersectAll(Expression<T> ... expressions) {
        return SetUtils.setOperation(JPQLNextOps.SET_INTERSECT_ALL, true, expressions);
    }

    @SafeVarargs
    public static <T> Expression<T> except(Expression<T> ... expressions) {
        return SetUtils.setOperation(JPQLNextOps.SET_EXCEPT, true, expressions);
    }

    @SafeVarargs
    public static <T> Expression<T> exceptAll(Expression<T> ... expressions) {
        return SetUtils.setOperation(JPQLNextOps.SET_EXCEPT_ALL, true, expressions);
    }

    private static class SetOperationVisitor<T>
    extends DefaultVisitorImpl<Expression<T>, Expression<T>> {
        private final boolean wrapSets;
        private final JPQLNextOps setOperation;
        private final JPQLNextOps leftNestedOperation;

        public SetOperationVisitor(JPQLNextOps setOperation, boolean wrapSets) {
            this.wrapSets = wrapSets;
            this.leftNestedOperation = SetUtils.getLeftNestedSetOperation(setOperation);
            this.setOperation = setOperation;
        }

        @Override
        public Expression<T> visit(Operation<?> lhs, Expression<T> rhs) {
            return ExpressionUtils.operation((Class)lhs.getType(), (Operator)(this.wrapSets ? this.leftNestedOperation : this.setOperation), (Expression[])new Expression[]{lhs, rhs});
        }

        @Override
        public Expression<T> visit(SubQueryExpression<?> lhs, Expression<T> rhs) {
            SetOperationFlag setOperationFlag = SetOperationFlag.getSetOperationFlag(lhs.getMetadata());
            boolean nestedSet = setOperationFlag != null;
            return ExpressionUtils.operation((Class)lhs.getType(), (Operator)(nestedSet && this.wrapSets ? this.leftNestedOperation : this.setOperation), (Expression[])new Expression[]{lhs, rhs});
        }
    }
}

