/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.querydsl;

import com.blazebit.persistence.querydsl.JPQLNextOps;
import com.blazebit.persistence.querydsl.JPQLNextTemplates;
import com.blazebit.persistence.querydsl.SetOperationFlag;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.support.SerializerBase;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.Visitor;
import com.querydsl.jpa.JPQLOps;
import com.querydsl.jpa.JPQLSerializer;
import com.querydsl.jpa.JPQLTemplates;
import java.lang.reflect.Field;
import java.util.List;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;

public class JPQLNextSerializer
extends JPQLSerializer {
    private static final Field BUILDER_FIELD;
    private final StringBuilder builder = JPQLNextSerializer.getStringBuilder(this);

    public JPQLNextSerializer() {
        this(JPQLNextTemplates.DEFAULT);
    }

    public JPQLNextSerializer(JPQLTemplates templates) {
        super(templates);
    }

    public JPQLNextSerializer(JPQLTemplates templates, EntityManager em) {
        super(templates, em);
    }

    public void serialize(QueryMetadata metadata, boolean forCountRow, @Nullable String projection) {
        SetOperationFlag setOperationFlag = SetOperationFlag.getSetOperationFlag(metadata);
        if (setOperationFlag != null) {
            setOperationFlag.getFlag().accept((Visitor)this, null);
        } else {
            super.serialize(metadata, forCountRow, projection);
        }
    }

    public Void visit(SubQueryExpression<?> query, Void context) {
        this.serialize(query.getMetadata(), false, null);
        return null;
    }

    protected void visitOperation(Class<?> type, Operator operator, List<? extends Expression<?>> args) {
        boolean wrapInParens = false;
        if (operator == JPQLOps.CAST) {
            try {
                operator = JPQLNextOps.valueOf("CAST_" + type.getSimpleName().toUpperCase());
                args = args.subList(0, 1);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else if (operator == Ops.MOD && type != Integer.class) {
            this.append("TREAT_" + type.getSimpleName().toUpperCase());
            wrapInParens = true;
        }
        if (wrapInParens) {
            this.append("(");
        }
        super.visitOperation(type, operator, args);
        if (wrapInParens) {
            this.append(")");
        }
    }

    public void clearBuffer() {
        this.builder.setLength(0);
    }

    public String takeBuffer() {
        String res = this.builder.toString();
        this.clearBuffer();
        return res;
    }

    private static StringBuilder getStringBuilder(JPQLNextSerializer serializer) {
        try {
            return (StringBuilder)BUILDER_FIELD.get((Object)serializer);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        try {
            Field builderField = SerializerBase.class.getDeclaredField("builder");
            builderField.setAccessible(true);
            BUILDER_FIELD = builderField;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

