/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Configuration;
import com.braintreegateway.OAuthConnectUrlRequest;
import com.braintreegateway.OAuthCredentials;
import com.braintreegateway.OAuthCredentialsRequest;
import com.braintreegateway.OAuthResult;
import com.braintreegateway.OAuthRevokeAccessTokenRequest;
import com.braintreegateway.Result;
import com.braintreegateway.util.Http;
import com.braintreegateway.util.NodeWrapper;
import com.braintreegateway.util.Sha256Hasher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuthGateway {
    private Http http;
    private Configuration configuration;

    public OAuthGateway(Http http, Configuration configuration) {
        this.http = http;
        this.configuration = configuration;
    }

    public Result<OAuthCredentials> createTokenFromCode(OAuthCredentialsRequest request) {
        request.grantType("authorization_code");
        NodeWrapper response = this.http.post("/oauth/access_tokens", request);
        return new Result<OAuthCredentials>(response, OAuthCredentials.class);
    }

    public Result<OAuthCredentials> createTokenFromRefreshToken(OAuthCredentialsRequest request) {
        request.grantType("refresh_token");
        NodeWrapper response = this.http.post("/oauth/access_tokens", request);
        return new Result<OAuthCredentials>(response, OAuthCredentials.class);
    }

    public Result<OAuthResult> revokeAccessToken(String accessToken) {
        OAuthRevokeAccessTokenRequest request = new OAuthRevokeAccessTokenRequest().token(accessToken);
        NodeWrapper response = this.http.post("/oauth/revoke_access_token", request);
        return new Result<OAuthResult>(response, OAuthResult.class);
    }

    public String connectUrl(OAuthConnectUrlRequest request) {
        request.clientId(this.configuration.getClientId());
        String queryString = request.toQueryString();
        String url = this.configuration.getBaseURL() + "/oauth/connect?" + queryString;
        return String.format("%1$s&signature=%2$s&algorithm=SHA256", url, this.computeSignature(url));
    }

    public String computeSignature(String url) {
        Sha256Hasher hasher = new Sha256Hasher();
        return hasher.hmacHash(this.configuration.getClientSecret(), url);
    }
}

