/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Configuration;
import com.braintreegateway.ResourceCollection;
import com.braintreegateway.Result;
import com.braintreegateway.Subscription;
import com.braintreegateway.SubscriptionPager;
import com.braintreegateway.SubscriptionRequest;
import com.braintreegateway.SubscriptionSearchRequest;
import com.braintreegateway.SubscriptionTransactionRequest;
import com.braintreegateway.Transaction;
import com.braintreegateway.exceptions.NotFoundException;
import com.braintreegateway.util.Http;
import com.braintreegateway.util.NodeWrapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptionGateway {
    private Http http;
    private Configuration configuration;

    public SubscriptionGateway(Http http, Configuration configuration) {
        this.http = http;
        this.configuration = configuration;
    }

    public Result<Subscription> cancel(String id) {
        NodeWrapper node = this.http.put(this.configuration.getMerchantPath() + "/subscriptions/" + id + "/cancel");
        return new Result<Subscription>(node, Subscription.class);
    }

    public Result<Subscription> create(SubscriptionRequest request) {
        NodeWrapper node = this.http.post(this.configuration.getMerchantPath() + "/subscriptions", request);
        return new Result<Subscription>(node, Subscription.class);
    }

    public Result<Subscription> delete(String customerId, String id) {
        this.http.delete(this.configuration.getMerchantPath() + "/subscriptions/" + id);
        return new Result<Subscription>();
    }

    public Subscription find(String id) {
        if (id == null || id.trim().equals("")) {
            throw new NotFoundException();
        }
        return new Subscription(this.http.get(this.configuration.getMerchantPath() + "/subscriptions/" + id));
    }

    public Result<Subscription> update(String id, SubscriptionRequest request) {
        NodeWrapper node = this.http.put(this.configuration.getMerchantPath() + "/subscriptions/" + id, request);
        return new Result<Subscription>(node, Subscription.class);
    }

    public ResourceCollection<Subscription> search(SubscriptionSearchRequest searchRequest) {
        NodeWrapper node = this.http.post(this.configuration.getMerchantPath() + "/subscriptions/advanced_search_ids", searchRequest);
        return new ResourceCollection<Subscription>(new SubscriptionPager(this, searchRequest), node);
    }

    List<Subscription> fetchSubscriptions(SubscriptionSearchRequest search, List<String> ids) {
        search.ids().in(ids);
        NodeWrapper response = this.http.post(this.configuration.getMerchantPath() + "/subscriptions/advanced_search", search);
        ArrayList<Subscription> items = new ArrayList<Subscription>();
        for (NodeWrapper node : response.findAll("subscription")) {
            items.add(new Subscription(node));
        }
        return items;
    }

    private Result<Transaction> retryCharge(SubscriptionTransactionRequest txnRequest) {
        NodeWrapper response = this.http.post(this.configuration.getMerchantPath() + "/transactions", txnRequest);
        return new Result<Transaction>(response, Transaction.class);
    }

    public Result<Transaction> retryCharge(String subscriptionId) {
        return this.retryCharge(new SubscriptionTransactionRequest().subscriptionId(subscriptionId));
    }

    public Result<Transaction> retryCharge(String subscriptionId, BigDecimal amount) {
        return this.retryCharge(new SubscriptionTransactionRequest().subscriptionId(subscriptionId).amount(amount));
    }
}

