/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway.test;

import com.braintreegateway.Configuration;
import com.braintreegateway.Environment;
import com.braintreegateway.Result;
import com.braintreegateway.Transaction;
import com.braintreegateway.exceptions.TestOperationPerformedInProductionException;
import com.braintreegateway.util.Http;
import com.braintreegateway.util.NodeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestingGateway {
    private Http http;
    private Configuration configuration;

    public TestingGateway(Http http, Configuration configuration) {
        this.configuration = configuration;
        this.http = http;
    }

    public Result<Transaction> settle(String transactionId) {
        this.checkEnvironment();
        NodeWrapper node = this.http.put(this.configuration.getMerchantPath() + "/transactions/" + transactionId + "/settle");
        return new Result<Transaction>(node, Transaction.class);
    }

    public Result<Transaction> settlementConfirm(String transactionId) {
        this.checkEnvironment();
        NodeWrapper node = this.http.put(this.configuration.getMerchantPath() + "/transactions/" + transactionId + "/settlement_confirm");
        return new Result<Transaction>(node, Transaction.class);
    }

    public Result<Transaction> settlementDecline(String transactionId) {
        this.checkEnvironment();
        NodeWrapper node = this.http.put(this.configuration.getMerchantPath() + "/transactions/" + transactionId + "/settlement_decline");
        return new Result<Transaction>(node, Transaction.class);
    }

    public Result<Transaction> settlementPending(String transactionId) {
        this.checkEnvironment();
        NodeWrapper node = this.http.put(this.configuration.getMerchantPath() + "/transactions/" + transactionId + "/settlement_pending");
        return new Result<Transaction>(node, Transaction.class);
    }

    private void checkEnvironment() throws TestOperationPerformedInProductionException {
        if (this.configuration.getEnvironment() == Environment.PRODUCTION) {
            throw new TestOperationPerformedInProductionException();
        }
    }
}

